/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.type.OBuffer;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ORawBuffer
extends OBuffer {
    public ORecordVersion version;
    public byte recordType;

    public ORawBuffer() {
        this.version = OVersionFactory.instance().createVersion();
    }

    public ORawBuffer(byte[] buffer, ORecordVersion version, byte recordType) {
        this.buffer = buffer;
        this.version = version.copy();
        this.recordType = recordType;
    }

    public ORawBuffer(ORecord iRecord) {
        this.buffer = iRecord.toStream();
        this.version = iRecord.getRecordVersion().copy();
        this.recordType = ORecordInternal.getRecordType(iRecord);
    }

    @Override
    public void readExternal(ObjectInput iInput) throws IOException, ClassNotFoundException {
        super.readExternal(iInput);
        this.version.getSerializer().readFrom(iInput, this.version);
        this.recordType = iInput.readByte();
    }

    @Override
    public void writeExternal(ObjectOutput iOutput) throws IOException {
        super.writeExternal(iOutput);
        this.version.getSerializer().writeTo(iOutput, this.version);
        iOutput.write(this.recordType);
    }
}

