/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OProjectionItem
extends SimpleNode {
    protected boolean all = false;
    protected String alias;
    protected OExpression expression;

    public OProjectionItem(int id) {
        super(id);
    }

    public OProjectionItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isAll() {
        if (this.all) {
            return true;
        }
        return this.expression != null && "*".equals(this.expression.toString());
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public OExpression getExpression() {
        return this.expression;
    }

    public void setExpression(OExpression expression) {
        this.expression = expression;
    }

    @Override
    public String toString(String prefix) {
        StringBuilder builder = new StringBuilder();
        if (this.all) {
            builder.append("*");
        } else {
            builder.append(this.expression.toString());
            if (this.alias != null && this.alias.trim().length() > 0) {
                builder.append(" AS " + this.alias);
            }
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public String getDefaultAlias() {
        if (this.expression == null) {
            return "null";
        }
        return this.expression.getDefaultAlias();
    }

    public void replaceParameters(Map<Object, Object> params) {
        if (this.expression != null) {
            this.expression.replaceParameters(params);
        }
    }
}

