/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OFunctionCall
extends SimpleNode {
    protected OIdentifier name;
    protected boolean star = false;
    protected List<OExpression> params = new ArrayList<OExpression>();

    public OFunctionCall(int id) {
        super(id);
    }

    public OFunctionCall(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isStar() {
        return this.star;
    }

    public void setStar(boolean star) {
        this.star = star;
    }

    public List<OExpression> getParams() {
        return this.params;
    }

    public void setParams(List<OExpression> params) {
        this.params = params;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name.toString());
        result.append("(");
        if (this.star) {
            result.append("*");
        } else {
            boolean first = true;
            for (OExpression expr : this.params) {
                if (!first) {
                    result.append(", ");
                }
                result.append(expr.toString());
                first = false;
            }
        }
        result.append(")");
        return result.toString();
    }

    public void replaceParameters(Map<Object, Object> iParams) {
        if (this.params != null) {
            for (OExpression expr : this.params) {
                expr.replaceParameters(iParams);
            }
        }
    }
}

