/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OInsertBody;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.List;
import java.util.Map;

public class OCreateEdgeStatement
extends OStatement {
    private static final Object unset = new Object();
    protected OIdentifier targetClass;
    protected OIdentifier targetClusterName;
    protected ORid leftRid;
    protected List<ORid> leftRids;
    protected OSelectStatement leftStatement;
    protected OInputParameter leftParam;
    protected Object leftParamValue = unset;
    protected OIdentifier leftIdentifier;
    protected ORid rightRid;
    protected List<ORid> rightRids;
    protected OSelectStatement rightStatement;
    protected OInputParameter rightParam;
    protected Object rightParamValue = unset;
    protected OIdentifier rightIdentifier;
    protected OInsertBody body;
    protected Number retry;
    protected Number wait;
    protected OBatch batch;

    public OCreateEdgeStatement(int id) {
        super(id);
    }

    public OCreateEdgeStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public String toString() {
        boolean first;
        StringBuilder result = new StringBuilder();
        result.append("CREATE EDGE");
        if (this.targetClass != null) {
            result.append(" ");
            result.append(this.targetClass.toString());
            if (this.targetClusterName != null) {
                result.append(" CLUSTER ");
                result.append(this.targetClusterName.toString());
            }
        }
        result.append(" FROM ");
        if (this.leftRid != null) {
            result.append(this.leftRid.toString());
        } else if (this.leftRids != null) {
            result.append("[");
            first = true;
            for (ORid rid : this.leftRids) {
                if (!first) {
                    result.append(", ");
                }
                result.append(rid.toString());
                first = false;
            }
            result.append("]");
        } else if (this.leftStatement != null) {
            result.append("(");
            result.append(this.leftStatement.toString());
            result.append(")");
        } else if (this.leftParam != null) {
            if (this.leftParamValue == unset) {
                result.append(this.leftParam.toString());
            } else if (this.leftParamValue == null) {
                result.append("NULL");
            } else if (this.leftParamValue instanceof String) {
                result.append("\"" + OExpression.encode("" + this.leftParamValue) + "\"");
            } else {
                result.append(this.leftParamValue.toString());
            }
        } else if (this.leftIdentifier != null) {
            result.append(this.leftIdentifier.toString());
        }
        result.append(" TO ");
        if (this.rightRid != null) {
            result.append(this.rightRid.toString());
        } else if (this.rightRids != null) {
            result.append("[");
            first = true;
            for (ORid rid : this.rightRids) {
                if (!first) {
                    result.append(", ");
                }
                result.append(rid.toString());
                first = false;
            }
            result.append("]");
        } else if (this.rightStatement != null) {
            result.append("(");
            result.append(this.rightStatement.toString());
            result.append(")");
        } else if (this.rightParam != null) {
            if (this.rightParamValue == unset) {
                result.append(this.rightParam.toString());
            } else if (this.rightParamValue == null) {
                result.append("NULL");
            } else if (this.rightParamValue instanceof String) {
                result.append("\"" + OExpression.encode("" + this.rightParamValue) + "\"");
            } else {
                result.append(this.rightParamValue.toString());
            }
        } else if (this.rightIdentifier != null) {
            result.append(this.rightIdentifier.toString());
        }
        if (this.body != null) {
            result.append(" ");
            result.append(this.body.toString());
        }
        if (this.retry != null) {
            result.append(" RETRY ");
            result.append(this.retry);
        }
        if (this.wait != null) {
            result.append(" WAIT ");
            result.append(this.wait);
        }
        if (this.batch != null) {
            result.append(this.batch.toString());
        }
        return result.toString();
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        Object val;
        if (this.leftStatement != null) {
            this.leftStatement.replaceParameters(params);
        }
        if (this.leftParam != null && (val = this.leftParam.bindFromInputParams(params)) != this.leftParam) {
            this.leftParamValue = val;
        }
        if (this.rightStatement != null) {
            this.rightStatement.replaceParameters(params);
        }
        if (this.rightParam != null && (val = this.rightParam.bindFromInputParams(params)) != this.rightParam) {
            this.rightParamValue = val;
        }
        if (this.body != null) {
            this.body.replaceParameters(params);
        }
        if (this.batch != null) {
            this.batch.replaceParameters(params);
        }
    }
}

