/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.Map;

public class OBaseExpression
extends OMathExpression {
    private static final Object UNSET = new Object();
    private Object inputFinalValue = UNSET;
    protected ONumber number;
    protected OBaseIdentifier identifier;
    protected OInputParameter inputParam;
    protected String string;
    OModifier modifier;

    public OBaseExpression(int id) {
        super(id);
    }

    public OBaseExpression(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.number != null) {
            result.append(this.number.toString());
        } else if (this.identifier != null) {
            result.append(this.identifier.toString());
        } else if (this.string != null) {
            result.append(this.string);
        } else if (this.inputParam != null) {
            if (this.inputFinalValue == UNSET) {
                result.append(this.inputParam.toString());
            } else if (this.inputFinalValue == null) {
                result.append("NULL");
            } else if (this.inputFinalValue instanceof String) {
                result.append("\"");
                result.append(OExpression.encode(this.inputFinalValue.toString()));
                result.append("\"");
            } else {
                result.append(this.inputFinalValue.toString());
            }
        }
        if (this.modifier != null) {
            result.append(this.modifier.toString());
        }
        return result.toString();
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        Object result;
        if (this.identifier != null) {
            this.identifier.replaceParameters(params);
        }
        if (this.inputParam != null && this.inputParam != (result = this.inputParam.bindFromInputParams(params))) {
            this.inputFinalValue = result;
        }
        if (this.modifier != null) {
            this.modifier.replaceParameters(params);
        }
    }

    @Override
    protected boolean supportsBasicCalculation() {
        return true;
    }
}

