/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import java.math.BigDecimal;
import java.util.Date;

public class OQueryOperatorMinus
extends OQueryOperator {
    public OQueryOperatorMinus() {
        super("-", 9, false);
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iRight == null) {
            return iLeft;
        }
        if (iLeft instanceof Date) {
            iLeft = ((Date)iLeft).getTime();
        }
        if (iRight instanceof Date) {
            iRight = ((Date)iRight).getTime();
        }
        if (iLeft instanceof Number && iRight instanceof Number) {
            Number l = (Number)iLeft;
            Number r = (Number)iRight;
            if (l instanceof Integer) {
                return l.intValue() - r.intValue();
            }
            if (l instanceof Long) {
                return l.longValue() - r.longValue();
            }
            if (l instanceof Short) {
                return l.shortValue() - r.shortValue();
            }
            if (l instanceof Float) {
                return Float.valueOf(l.floatValue() - r.floatValue());
            }
            if (l instanceof Double) {
                return l.doubleValue() - r.doubleValue();
            }
            if (l instanceof BigDecimal) {
                if (r instanceof BigDecimal) {
                    return ((BigDecimal)l).subtract((BigDecimal)r);
                }
                if (r instanceof Float) {
                    return ((BigDecimal)l).subtract(new BigDecimal(r.floatValue()));
                }
                if (r instanceof Double) {
                    return ((BigDecimal)l).subtract(new BigDecimal(r.doubleValue()));
                }
                if (r instanceof Long) {
                    return ((BigDecimal)l).subtract(new BigDecimal(r.longValue()));
                }
                if (r instanceof Integer) {
                    return ((BigDecimal)l).subtract(new BigDecimal(r.intValue()));
                }
                if (r instanceof Short) {
                    return ((BigDecimal)l).subtract(new BigDecimal(r.shortValue()));
                }
            }
        }
        return null;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

