/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.stat;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLFunctionVariance
extends OSQLFunctionAbstract {
    public static final String NAME = "variance";
    private long n;
    private double mean;
    private double m2;

    public OSQLFunctionVariance() {
        super(NAME, 1, 1);
    }

    public OSQLFunctionVariance(String iName, int iMinParams, int iMaxParams) {
        super(iName, iMaxParams, iMaxParams);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams[0] instanceof Number) {
            this.addValue((Number)iParams[0]);
        } else if (OMultiValue.isMultiValue(iParams[0])) {
            for (Object n : OMultiValue.getMultiValueIterable(iParams[0])) {
                this.addValue((Number)n);
            }
        }
        return null;
    }

    @Override
    public boolean aggregateResults() {
        return true;
    }

    @Override
    public Object getResult() {
        if (this.returnDistributedResult()) {
            HashMap<String, Number> doc = new HashMap<String, Number>();
            doc.put("n", this.n);
            doc.put("mean", this.mean);
            doc.put("var", this.evaluate());
            return doc;
        }
        return this.evaluate();
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        if (this.returnDistributedResult()) {
            long dN = 0L;
            double dMean = 0.0;
            Double var = null;
            for (Object iParameter : resultsToMerge) {
                Map item = (Map)iParameter;
                if (dN == 0L) {
                    dN = (Long)item.get("n");
                    dMean = (Double)item.get("mean");
                    var = (Double)item.get("var");
                    continue;
                }
                long rhsN = (Long)item.get("n");
                double rhsMean = (Double)item.get("mean");
                double rhsVar = (Double)item.get("var");
                long totalN = dN + rhsN;
                double totalMean = (dMean * (double)dN + rhsMean * (double)rhsN) / (double)totalN;
                var = ((double)dN * var + (double)rhsN * rhsVar) / (double)totalN + (double)(dN * rhsN) * Math.pow((rhsMean - dMean) / (double)totalN, 2.0);
                dN = totalN;
                dMean = totalMean;
            }
            return var;
        }
        return resultsToMerge.get(0);
    }

    @Override
    public String getSyntax() {
        return "variance(<field>)";
    }

    private void addValue(Number value) {
        if (value != null) {
            ++this.n;
            double doubleValue = value.doubleValue();
            double nextM = this.mean + (doubleValue - this.mean) / (double)this.n;
            this.m2 += (doubleValue - this.mean) * (doubleValue - nextM);
            this.mean = nextM;
        }
    }

    private Double evaluate() {
        return this.n > 1L ? Double.valueOf(this.m2 / (double)this.n) : null;
    }
}

