/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import java.util.List;

public class OSQLFunctionRuntime
extends OSQLFilterItemAbstract {
    public OSQLFunction function;
    public Object[] configuredParameters;
    public Object[] runtimeParameters;

    public OSQLFunctionRuntime(OBaseParser iQueryToParse, String iText) {
        super(iQueryToParse, iText);
    }

    public OSQLFunctionRuntime(OSQLFunction iFunction) {
        this.function = iFunction;
    }

    public boolean aggregateResults() {
        return this.function.aggregateResults();
    }

    public boolean filterResult() {
        return this.function.filterResult();
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, OCommandContext iContext) {
        for (int i = 0; i < this.configuredParameters.length; ++i) {
            this.runtimeParameters[i] = this.configuredParameters[i];
            if (this.configuredParameters[i] instanceof OSQLFilterItemField) {
                this.runtimeParameters[i] = ((OSQLFilterItemField)this.configuredParameters[i]).getValue(iCurrentRecord, iCurrentResult, iContext);
                continue;
            }
            if (this.configuredParameters[i] instanceof OSQLFunctionRuntime) {
                this.runtimeParameters[i] = ((OSQLFunctionRuntime)this.configuredParameters[i]).execute(iThis, iCurrentRecord, iCurrentResult, iContext);
                continue;
            }
            if (this.configuredParameters[i] instanceof OSQLFilterItemVariable) {
                this.runtimeParameters[i] = ((OSQLFilterItemVariable)this.configuredParameters[i]).getValue(iCurrentRecord, iCurrentResult, iContext);
                continue;
            }
            if (this.configuredParameters[i] instanceof OCommandSQL) {
                try {
                    this.runtimeParameters[i] = ((OCommandSQL)this.configuredParameters[i]).setContext(iContext).execute(new Object[0]);
                }
                catch (OCommandExecutorNotFoundException e) {
                    String text = ((OCommandSQL)this.configuredParameters[i]).getText();
                    OSQLPredicate pred = new OSQLPredicate(text);
                    this.runtimeParameters[i] = pred.evaluate(iCurrentRecord instanceof ORecord ? (ORecord)iCurrentRecord : null, (ODocument)iCurrentResult, iContext);
                    this.configuredParameters[i] = pred;
                }
                continue;
            }
            if (this.configuredParameters[i] instanceof OSQLPredicate) {
                this.runtimeParameters[i] = ((OSQLPredicate)this.configuredParameters[i]).evaluate((OIdentifiable)iCurrentRecord.getRecord(), iCurrentRecord instanceof ODocument ? (ODocument)iCurrentResult : null, iContext);
                continue;
            }
            if (!(this.configuredParameters[i] instanceof String) || !this.configuredParameters[i].toString().startsWith("\"") && !this.configuredParameters[i].toString().startsWith("'")) continue;
            this.runtimeParameters[i] = OStringSerializerHelper.getStringContent(this.configuredParameters[i]);
        }
        if ((this.function.getMaxParams() == -1 || this.function.getMaxParams() > 0) && (this.runtimeParameters.length < this.function.getMinParams() || this.function.getMaxParams() > -1 && this.runtimeParameters.length > this.function.getMaxParams())) {
            throw new OCommandExecutionException("Syntax error: function '" + this.function.getName() + "' needs " + (this.function.getMinParams() == this.function.getMaxParams() ? Integer.valueOf(this.function.getMinParams()) : this.function.getMinParams() + "-" + this.function.getMaxParams()) + " argument(s) while has been received " + this.runtimeParameters.length);
        }
        Object functionResult = this.function.execute(iThis, iCurrentRecord, iCurrentResult, this.runtimeParameters, iContext);
        if (functionResult instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)functionResult).setAutoConvertToRecord(false);
        }
        return this.transformValue(iCurrentRecord, iContext, functionResult);
    }

    public Object getResult() {
        return this.transformValue(null, null, this.function.getResult());
    }

    public void setResult(Object iValue) {
        this.function.setResult(iValue);
    }

    @Override
    public Object getValue(OIdentifiable iRecord, Object iCurrentResult, OCommandContext iContext) {
        ODocument current = iRecord != null ? (ODocument)iRecord.getRecord() : null;
        return this.execute(current, current, null, iContext);
    }

    @Override
    public String getRoot() {
        return this.function.getName();
    }

    public OSQLFunctionRuntime setParameters(Object[] iParameters, boolean iEvaluate) {
        int i;
        this.configuredParameters = new Object[iParameters.length];
        for (i = 0; i < iParameters.length; ++i) {
            this.configuredParameters[i] = iParameters[i];
            if (!iEvaluate) continue;
            if (iParameters[i] != null) {
                Object v;
                if (!(iParameters[i] instanceof String) || iParameters[i].toString().startsWith("[") || (v = OSQLHelper.parseValue(null, null, iParameters[i].toString(), null)) == "_NOT_PARSED_" || v != null && OMultiValue.isMultiValue(v) && OMultiValue.getFirstValue(v) == "_NOT_PARSED_") continue;
                this.configuredParameters[i] = v;
                continue;
            }
            this.configuredParameters[i] = null;
        }
        this.function.config(this.configuredParameters);
        this.runtimeParameters = new Object[this.configuredParameters.length];
        for (i = 0; i < this.configuredParameters.length; ++i) {
            if (this.configuredParameters[i] instanceof OSQLFilterItemField || this.configuredParameters[i] instanceof OSQLFunctionRuntime) continue;
            this.runtimeParameters[i] = this.configuredParameters[i];
        }
        return this;
    }

    public OSQLFunction getFunction() {
        return this.function;
    }

    public Object[] getConfiguredParameters() {
        return this.configuredParameters;
    }

    public Object[] getRuntimeParameters() {
        return this.runtimeParameters;
    }

    @Override
    protected void setRoot(OBaseParser iQueryToParse, String iText) {
        int beginParenthesis = iText.indexOf(40);
        String funcName = iText.substring(0, beginParenthesis);
        List<String> funcParamsText = OStringSerializerHelper.getParameters(iText);
        this.function = OSQLEngine.getInstance().getFunction(funcName);
        if (this.function == null) {
            throw new OCommandSQLParsingException("Unknown function " + funcName + "()");
        }
        this.configuredParameters = new Object[funcParamsText.size()];
        for (int i = 0; i < funcParamsText.size(); ++i) {
            this.configuredParameters[i] = funcParamsText.get(i);
        }
        this.setParameters(this.configuredParameters, true);
    }
}

