/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.string;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializer;

public class OStringSerializerEmbedded
implements OStringSerializer {
    public static final OStringSerializerEmbedded INSTANCE = new OStringSerializerEmbedded();
    public static final String NAME = "em";

    @Override
    public Object fromStream(String iStream) {
        if (iStream == null || iStream.length() == 0) {
            return null;
        }
        ODocument instance = new ODocument();
        instance.fromStream(OBinaryProtocol.string2bytes(iStream));
        String className = (String)instance.field("__orientdb_serilized_class__ ");
        if (className == null) {
            return instance;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            OLogManager.instance().debug((Object)this, "Class name provided in embedded document " + className + " does not exist.", new Object[0]);
        }
        if (clazz == null) {
            return instance;
        }
        if (ODocumentSerializable.class.isAssignableFrom(clazz)) {
            try {
                ODocumentSerializable documentSerializable = (ODocumentSerializable)clazz.newInstance();
                ODocument docClone = new ODocument();
                instance.copyTo(docClone);
                docClone.removeField("__orientdb_serilized_class__ ");
                documentSerializable.fromDocument(docClone);
                return documentSerializable;
            }
            catch (InstantiationException e) {
                throw new OSerializationException("Cannot serialize the object", e);
            }
            catch (IllegalAccessException e) {
                throw new OSerializationException("Cannot serialize the object", e);
            }
        }
        return instance;
    }

    @Override
    public StringBuilder toStream(StringBuilder iOutput, Object iValue) {
        if (iValue != null) {
            if (iValue instanceof ODocumentSerializable) {
                iValue = ((ODocumentSerializable)iValue).toDocument();
            }
            if (!(iValue instanceof OSerializableStream)) {
                throw new OSerializationException("Cannot serialize the object since it's not implements the OSerializableStream interface");
            }
            OSerializableStream stream = (OSerializableStream)iValue;
            iOutput.append(iValue.getClass().getName());
            iOutput.append("|");
            iOutput.append(OBinaryProtocol.bytes2string(stream.toStream()));
        }
        return iOutput;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

