/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebug;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebugProperty;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV0;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import java.util.ArrayList;

public class ORecordSerializerBinaryDebug
extends ORecordSerializerBinaryV0 {
    public ORecordSerializationDebug deserializeDebug(byte[] iSource, ODatabaseDocumentTx db) {
        ORecordSerializationDebug debugInfo = new ORecordSerializationDebug();
        OImmutableSchema schema = db.getMetadata().getImmutableSchemaSnapshot();
        BytesContainer bytes = new BytesContainer(iSource);
        if (bytes.bytes[0] != 0) {
            throw new OException("Unsupported binary serialization version");
        }
        bytes.skip(1);
        try {
            String className;
            debugInfo.className = className = this.readString(bytes);
        }
        catch (RuntimeException ex) {
            debugInfo.readingFailure = true;
            debugInfo.readingException = ex;
            debugInfo.failPosition = bytes.offset;
            return debugInfo;
        }
        debugInfo.properties = new ArrayList();
        int last = 0;
        while (true) {
            ORecordSerializationDebugProperty debugProperty = new ORecordSerializationDebugProperty();
            OGlobalProperty prop = null;
            try {
                OType type;
                int valuePos;
                String fieldName;
                int len = OVarIntSerializer.readAsInteger(bytes);
                if (len != 0) {
                    debugInfo.properties.add(debugProperty);
                }
                if (len == 0) break;
                if (len > 0) {
                    fieldName = this.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                    bytes.skip(len);
                    valuePos = this.readInteger(bytes);
                    type = this.readOType(bytes);
                } else {
                    int id;
                    debugProperty.globalId = id = len * -1 - 1;
                    prop = schema.getGlobalPropertyById(id);
                    fieldName = prop.getName();
                    valuePos = this.readInteger(bytes);
                    type = prop.getType() != OType.ANY ? prop.getType() : this.readOType(bytes);
                }
                debugProperty.name = fieldName;
                debugProperty.type = type;
                if (valuePos != 0) {
                    int headerCursor = bytes.offset;
                    bytes.offset = valuePos;
                    try {
                        debugProperty.value = this.readSingleValue(bytes, type, new ODocument());
                    }
                    catch (RuntimeException ex) {
                        debugProperty.faildToRead = true;
                        debugProperty.readingException = ex;
                        debugProperty.failPosition = bytes.offset;
                    }
                    if (bytes.offset > last) {
                        last = bytes.offset;
                    }
                    bytes.offset = headerCursor;
                    continue;
                }
                debugProperty.value = null;
            }
            catch (RuntimeException ex) {
                debugInfo.readingFailure = true;
                debugInfo.readingException = ex;
                debugInfo.failPosition = bytes.offset;
                return debugInfo;
            }
        }
        return debugInfo;
    }
}

