/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationSetThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV0;

public class ORecordSerializerBinary
implements ORecordSerializer {
    public static final String NAME = "ORecordSerializerBinary";
    public static final ORecordSerializerBinary INSTANCE = new ORecordSerializerBinary();
    private static final byte CURRENT_RECORD_VERSION = 0;
    private ODocumentSerializer[] serializerByVersion = new ODocumentSerializer[1];

    public ORecordSerializerBinary() {
        this.serializerByVersion[0] = new ORecordSerializerBinaryV0();
    }

    @Override
    public int getCurrentVersion() {
        return 0;
    }

    @Override
    public int getMinSupportedVersion() {
        return 0;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        if (iSource.length == 0) {
            return iRecord;
        }
        if (iRecord == null) {
            iRecord = new ODocument();
        } else {
            this.checkTypeODocument(iRecord);
        }
        BytesContainer container = new BytesContainer(iSource);
        container.skip(1);
        try {
            if (iFields != null && iFields.length > 0) {
                this.serializerByVersion[iSource[0]].deserializePartial((ODocument)iRecord, container, iFields);
            } else {
                this.serializerByVersion[iSource[0]].deserialize((ODocument)iRecord, container);
            }
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record with id %s send this data for debugging: %s ", iRecord.getIdentity().toString(), OBase64Utils.encodeBytes(iSource));
            throw e;
        }
        return iRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toStream(ORecord iSource, boolean iOnlyDelta) {
        this.checkTypeODocument(iSource);
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = 0;
        if (!OSerializationSetThreadLocal.checkAndAdd((ODocument)iSource)) {
            this.serializerByVersion[0].serialize((ODocument)iSource, container, true);
            OSerializationSetThreadLocal.setPartial((ODocument)iSource);
            return container.fitBytes();
        }
        try {
            this.serializerByVersion[0].serialize((ODocument)iSource, container, false);
        }
        finally {
            OSerializationSetThreadLocal.removeCheck((ODocument)iSource);
        }
        return container.fitBytes();
    }

    private void checkTypeODocument(ORecord iRecord) {
        if (!(iRecord instanceof ODocument)) {
            throw new UnsupportedOperationException("The ORecordSerializerBinary don't support record of type " + iRecord.getClass().getName());
        }
    }
}

