/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.IdentityHashMap;
import java.util.Map;

public class OSerializationSetThreadLocal
extends ThreadLocal<Map<ODocument, Boolean>> {
    public static OSerializationSetThreadLocal INSTANCE = new OSerializationSetThreadLocal();

    public static boolean check(ODocument document) {
        return ((Map)INSTANCE.get()).containsKey(document);
    }

    public static boolean checkIfPartial(ODocument document) {
        Boolean partial = (Boolean)((Map)INSTANCE.get()).get(document);
        if (partial != null) {
            return partial;
        }
        return false;
    }

    public static void setPartial(ODocument document) {
        ((Map)INSTANCE.get()).put(document, Boolean.TRUE);
    }

    public static boolean checkAndAdd(ODocument document) {
        Map iMarshalledRecords = (Map)INSTANCE.get();
        if (iMarshalledRecords.containsKey(document)) {
            return false;
        }
        iMarshalledRecords.put(document, Boolean.FALSE);
        return true;
    }

    public static void clear() {
        ((Map)INSTANCE.get()).clear();
    }

    public static void removeCheck(ODocument document) {
        ((Map)INSTANCE.get()).remove(document);
    }

    @Override
    protected Map<ODocument, Boolean> initialValue() {
        return new IdentityHashMap<ODocument, Boolean>();
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (INSTANCE == null) {
                    INSTANCE = new OSerializationSetThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                INSTANCE = null;
            }
        });
    }
}

