/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;

public class OSimpleKeySerializer<T extends Comparable<?>>
implements OBinarySerializer<T> {
    private OType type;
    private OBinarySerializer binarySerializer;
    public static final byte ID = 15;
    public static final String NAME = "bsks";

    public OSimpleKeySerializer() {
    }

    public OSimpleKeySerializer(OType iType) {
        this.type = iType;
        this.binarySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(iType);
    }

    @Override
    public int getObjectSize(T key, Object ... hints) {
        this.init(key, hints);
        return 1 + this.binarySerializer.getObjectSize(key, new Object[0]);
    }

    @Override
    public void serialize(T key, byte[] stream, int startPosition, Object ... hints) {
        this.init(key, hints);
        stream[startPosition] = this.binarySerializer.getId();
        this.binarySerializer.serialize(key, stream, ++startPosition, new Object[0]);
    }

    @Override
    public T deserialize(byte[] stream, int startPosition) {
        byte typeId = stream[startPosition];
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserialize(stream, ++startPosition));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        byte serializerId = stream[startPosition];
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSize(stream, startPosition + 1);
    }

    @Override
    public byte getId() {
        return 15;
    }

    protected void init(T key, Object[] hints) {
        if (this.binarySerializer == null) {
            OType[] types = hints != null && hints.length > 0 ? (OType[])hints : OCommonConst.EMPTY_TYPES_ARRAY;
            this.type = types.length > 0 ? types[0] : OType.getTypeByClass(key.getClass());
            this.binarySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(this.type);
        }
    }

    protected void init(byte serializerId) {
        if (this.binarySerializer == null) {
            this.binarySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
        }
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        byte serializerId = stream[startPosition];
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSizeNative(stream, startPosition + 1);
    }

    @Override
    public void serializeNativeObject(T key, byte[] stream, int startPosition, Object ... hints) {
        this.init(key, hints);
        stream[startPosition] = this.binarySerializer.getId();
        this.binarySerializer.serializeNativeObject(key, stream, ++startPosition, new Object[0]);
    }

    @Override
    public T deserializeNativeObject(byte[] stream, int startPosition) {
        byte typeId = stream[startPosition];
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeNativeObject(stream, ++startPosition));
    }

    @Override
    public void serializeInDirectMemoryObject(T object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        this.init(object, hints);
        pointer.setByte(offset++, this.binarySerializer.getId());
        this.binarySerializer.serializeInDirectMemoryObject(object, pointer, offset, new Object[0]);
    }

    @Override
    public T deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        byte typeId = pointer.getByte(offset++);
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeFromDirectMemoryObject(pointer, offset));
    }

    @Override
    public T deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        byte typeId = wrapper.getByte(offset++);
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeFromDirectMemoryObject(wrapper, offset));
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        byte serializerId = pointer.getByte(offset);
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSizeInDirectMemory(pointer, 1L + offset);
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        byte serializerId = wrapper.getByte(offset);
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSizeInDirectMemory(wrapper, 1L + offset);
    }

    @Override
    public boolean isFixedLength() {
        return this.binarySerializer.isFixedLength();
    }

    @Override
    public int getFixedLength() {
        return this.binarySerializer.getFixedLength() + 1;
    }

    @Override
    public T preprocess(T value, Object ... hints) {
        this.init(value, hints);
        return (T)((Comparable)this.binarySerializer.preprocess(value, new Object[0]));
    }
}

