/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;
import java.util.List;

public class OCompositeKeySerializer
implements OBinarySerializer<OCompositeKey>,
OStreamSerializer {
    public static final String NAME = "cks";
    public static final OCompositeKeySerializer INSTANCE = new OCompositeKeySerializer();
    public static final byte ID = 14;

    @Override
    public int getObjectSize(OCompositeKey compositeKey, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = compositeKey.getKeys();
        int size = 8;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                size += 1 + factory.getObjectSerializer(type).getObjectSize(key, new Object[0]);
                continue;
            }
            size += 1 + ONullSerializer.INSTANCE.getObjectSize((Object)null, new Object[0]);
        }
        return size;
    }

    @Override
    public void serialize(OCompositeKey compositeKey, byte[] stream, int startPosition, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = compositeKey.getKeys();
        int keysSize = keys.size();
        int oldStartPosition = startPosition;
        OIntegerSerializer.INSTANCE.serializeLiteral(keysSize, stream, startPosition += 4);
        startPosition += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            OBinarySerializer<Object> binarySerializer;
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                binarySerializer = factory.getObjectSerializer(type);
            } else {
                binarySerializer = ONullSerializer.INSTANCE;
            }
            stream[startPosition] = binarySerializer.getId();
            binarySerializer.serialize(key, stream, ++startPosition, new Object[0]);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        OIntegerSerializer.INSTANCE.serializeLiteral(startPosition - oldStartPosition, stream, oldStartPosition);
    }

    @Override
    public OCompositeKey deserialize(byte[] stream, int startPosition) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition += 4);
        startPosition += OIntegerSerializer.INSTANCE.getObjectSize(keysSize, new Object[0]);
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = stream[startPosition];
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserialize(stream, ++startPosition);
            compositeKey.addKey(key);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        return compositeKey;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
    }

    @Override
    public byte getId() {
        return 14;
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        throw new UnsupportedOperationException("CSV storage format is out of dated and is not supported.");
    }

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        OCompositeKey compositeKey = new OCompositeKey();
        OMemoryInputStream inputStream = new OMemoryInputStream(iStream);
        int keysSize = inputStream.getAsInteger();
        for (int i = 0; i < keysSize; ++i) {
            byte[] keyBytes = inputStream.getAsByteArray();
            String keyString = OBinaryProtocol.bytes2string(keyBytes);
            int typeSeparatorPos = keyString.indexOf(44);
            OType type = OType.valueOf(keyString.substring(0, typeSeparatorPos));
            compositeKey.addKey(ORecordSerializerStringAbstract.simpleValueFromStream(keyString.substring(typeSeparatorPos + 1), type));
        }
        return compositeKey;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
    }

    @Override
    public void serializeNativeObject(OCompositeKey compositeKey, byte[] stream, int startPosition, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = compositeKey.getKeys();
        int keysSize = keys.size();
        int oldStartPosition = startPosition;
        OIntegerSerializer.INSTANCE.serializeNative(keysSize, stream, startPosition += 4, new Object[0]);
        startPosition += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            OBinarySerializer<Object> binarySerializer;
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                binarySerializer = factory.getObjectSerializer(type);
            } else {
                binarySerializer = ONullSerializer.INSTANCE;
            }
            stream[startPosition] = binarySerializer.getId();
            binarySerializer.serializeNativeObject(key, stream, ++startPosition, new Object[0]);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        OIntegerSerializer.INSTANCE.serializeNative(startPosition - oldStartPosition, stream, oldStartPosition, new Object[0]);
    }

    @Override
    public OCompositeKey deserializeNativeObject(byte[] stream, int startPosition) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition += 4);
        startPosition += OIntegerSerializer.INSTANCE.getObjectSize(keysSize, new Object[0]);
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = stream[startPosition];
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeNativeObject(stream, ++startPosition);
            compositeKey.addKey(key);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        return compositeKey;
    }

    @Override
    public void serializeInDirectMemoryObject(OCompositeKey compositeKey, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = compositeKey.getKeys();
        int keysSize = keys.size();
        long oldStartOffset = offset;
        pointer.setInt(offset += 4L, keysSize);
        offset += 4L;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            OBinarySerializer<Object> binarySerializer;
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                binarySerializer = factory.getObjectSerializer(type);
            } else {
                binarySerializer = ONullSerializer.INSTANCE;
            }
            pointer.setByte(offset, binarySerializer.getId());
            binarySerializer.serializeInDirectMemoryObject(key, pointer, ++offset, new Object[0]);
            offset += (long)binarySerializer.getObjectSize(key, new Object[0]);
        }
        pointer.setInt(oldStartOffset, (int)(offset - oldStartOffset));
    }

    private OType[] getKeyTypes(Object[] hints) {
        OType[] types = hints != null && hints.length > 0 ? (OType[])hints : OCommonConst.EMPTY_TYPES_ARRAY;
        return types;
    }

    @Override
    public OCompositeKey deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = pointer.getInt(offset += 4L);
        offset += 4L;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = pointer.getByte(offset);
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeFromDirectMemoryObject(pointer, ++offset);
            compositeKey.addKey(key);
            offset += (long)binarySerializer.getObjectSize(key, new Object[0]);
        }
        return compositeKey;
    }

    @Override
    public OCompositeKey deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = wrapper.getInt(offset += 4L);
        offset += 4L;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = wrapper.getByte(offset);
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeFromDirectMemoryObject(wrapper, ++offset);
            compositeKey.addKey(key);
            offset += (long)binarySerializer.getObjectSize(key, new Object[0]);
        }
        return compositeKey;
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getInt(offset);
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getInt(offset);
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public OCompositeKey preprocess(OCompositeKey value, Object ... hints) {
        if (value == null) {
            return null;
        }
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = value.getKeys();
        OCompositeKey compositeKey = new OCompositeKey();
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
            OBinarySerializer<Object> keySerializer = factory.getObjectSerializer(type);
            compositeKey.addKey(keySerializer.preprocess(key, new Object[0]));
        }
        return compositeKey;
    }
}

