/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;

final class OSimpleMultiValueChangeListener<K, V>
implements OMultiValueChangeListener<K, V> {
    private final ODocument oDocument;
    private final ODocumentEntry entry;

    OSimpleMultiValueChangeListener(ODocument oDocument, ODocumentEntry entry) {
        this.oDocument = oDocument;
        this.entry = entry;
    }

    @Override
    public void onAfterRecordChanged(OMultiValueChangeEvent<K, V> event) {
        if (this.oDocument.getInternalStatus() != ORecordElement.STATUS.UNMARSHALLING) {
            if (event.isChangesOwnerContent()) {
                this.oDocument.setDirty();
            } else {
                this.oDocument.setDirtyNoChanged();
            }
        }
        if (!this.oDocument._trackingChanges || !this.oDocument.getIdentity().isValid() || this.oDocument.getInternalStatus() == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        if (this.entry == null || this.entry.isChanged()) {
            return;
        }
        if (this.entry.timeLine == null) {
            this.entry.timeLine = new OMultiValueChangeTimeLine();
        }
        this.entry.timeLine.addCollectionChangeEvent(event);
    }
}

