/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.query.live.OLiveQueryListener;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class OLiveQueryQueueThread
extends Thread {
    private final BlockingQueue<ORecordOperation> queue = new LinkedBlockingQueue<ORecordOperation>();
    private final Map<Integer, OLiveQueryListener> subscribers = new ConcurrentHashMap<Integer, OLiveQueryListener>();
    private boolean stopped = false;

    public OLiveQueryQueueThread() {
        this.setName("LiveQueryQueueThread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            ORecordOperation next = null;
            try {
                next = this.queue.take();
            }
            catch (InterruptedException e) {
                break;
            }
            if (next == null) continue;
            for (OLiveQueryListener listener : this.subscribers.values()) {
                listener.onLiveResult(next);
            }
        }
    }

    public void stopExecution() {
        this.stopped = true;
        this.queue.notifyAll();
    }

    public void enqueue(ORecordOperation item) {
        this.queue.offer(item);
    }

    public Integer subscribe(Integer id, OLiveQueryListener iListener) {
        this.subscribers.put(id, iListener);
        return id;
    }

    public void unsubscribe(Integer id) {
        this.subscribers.remove(id);
    }
}

