/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class OIndexTxAwareOneValue
extends OIndexTxAware<OIdentifiable> {
    public OIndexTxAwareOneValue(ODatabaseDocumentInternal iDatabase, OIndex<OIdentifiable> iDelegate) {
        super(iDatabase, iDelegate);
    }

    @Override
    public ODocument checkEntry(OIdentifiable iRecord, Object iKey) {
        if (!this.database.getTransaction().isActive()) {
            OIdentifiable previousRecord = this.get(iKey);
            if (previousRecord != null && !previousRecord.equals(iRecord)) {
                boolean mergeSameKey;
                ODocument metadata = this.getMetadata();
                Boolean mergeKeys = false;
                if (metadata != null) {
                    mergeKeys = (Boolean)metadata.field("mergeKeys");
                }
                boolean bl = mergeSameKey = mergeKeys != null && mergeKeys != false;
                if (mergeSameKey) {
                    return (ODocument)previousRecord.getRecord();
                }
                throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", iRecord, iKey, this.getName(), previousRecord), previousRecord.getIdentity());
            }
            return super.checkEntry(iRecord, iKey);
        }
        return null;
    }

    @Override
    public OIdentifiable get(Object key) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return (OIdentifiable)super.get(key);
        }
        OIdentifiable result = !indexChanges.cleared ? (OIdentifiable)super.get(key) : null;
        Map.Entry<Object, OIdentifiable> entry = this.calculateTxIndexEntry(key, result, indexChanges);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public boolean contains(Object key) {
        return this.get(key) != null;
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        }
        OIndexAbstractCursor txCursor = ascOrder ? new PureTxBetweenIndexForwardCursor(fromKey, fromInclusive, toKey, toInclusive, indexChanges) : new PureTxBetweenIndexBackwardCursor(fromKey, fromInclusive, toKey, toInclusive, indexChanges);
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascOrder, indexChanges);
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntriesMajor(fromKey, fromInclusive, ascOrder);
        }
        Object lastKey = indexChanges.getLastKey();
        OIndexAbstractCursor txCursor = ascOrder ? new PureTxBetweenIndexForwardCursor(fromKey, fromInclusive, lastKey, true, indexChanges) : new PureTxBetweenIndexBackwardCursor(fromKey, fromInclusive, lastKey, true, indexChanges);
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntriesMajor(fromKey, fromInclusive, ascOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascOrder, indexChanges);
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntriesMinor(toKey, toInclusive, ascOrder);
        }
        Object firstKey = indexChanges.getFirstKey();
        OIndexAbstractCursor txCursor = ascOrder ? new PureTxBetweenIndexForwardCursor(firstKey, true, toKey, toInclusive, indexChanges) : new PureTxBetweenIndexBackwardCursor(firstKey, true, toKey, toInclusive, indexChanges);
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntriesMinor(toKey, toInclusive, ascOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascOrder, indexChanges);
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        final OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.iterateEntries(keys, ascSortOrder);
        }
        final ArrayList sortedKeys = new ArrayList(keys);
        if (ascSortOrder) {
            Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        } else {
            Collections.sort(sortedKeys, Collections.reverseOrder(ODefaultComparator.INSTANCE));
        }
        OIndexAbstractCursor txCursor = new OIndexAbstractCursor(){
            private Iterator<Object> keysIterator;
            {
                this.keysIterator = sortedKeys.iterator();
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.keysIterator == null) {
                    return null;
                }
                Map.Entry entry = null;
                while (entry == null && this.keysIterator.hasNext()) {
                    Object key = this.keysIterator.next();
                    entry = OIndexTxAwareOneValue.this.calculateTxIndexEntry(key, null, indexChanges);
                }
                if (entry == null) {
                    this.keysIterator = null;
                    return null;
                }
                return entry;
            }
        };
        if (indexChanges.cleared) {
            return txCursor;
        }
        OIndexCursor backedCursor = super.iterateEntries(keys, ascSortOrder);
        return new OIndexTxCursor(txCursor, backedCursor, ascSortOrder, indexChanges);
    }

    private Map.Entry<Object, OIdentifiable> calculateTxIndexEntry(Object key, OIdentifiable backendValue, OTransactionIndexChanges indexChanges) {
        OTransactionIndexChangesPerKey changesPerKey = indexChanges.getChangesPerKey(key);
        if (changesPerKey.entries.isEmpty()) {
            if (backendValue == null) {
                return null;
            }
            return this.createMapEntry(key, backendValue);
        }
        OIdentifiable result = backendValue;
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.entries) {
            if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                result = null;
                continue;
            }
            if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
            result = entry.value;
        }
        if (result == null) {
            return null;
        }
        OIdentifiable resultValue = result;
        return this.createMapEntry(key, resultValue);
    }

    private Map.Entry<Object, OIdentifiable> createMapEntry(final Object key, final OIdentifiable resultValue) {
        return new Map.Entry<Object, OIdentifiable>(){

            @Override
            public Object getKey() {
                return key;
            }

            @Override
            public OIdentifiable getValue() {
                return resultValue;
            }

            @Override
            public OIdentifiable setValue(OIdentifiable value) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private class OIndexTxCursor
    extends OIndexAbstractCursor {
        private final OIndexCursor backedCursor;
        private final boolean ascOrder;
        private final OTransactionIndexChanges indexChanges;
        private OIndexCursor txBetweenIndexCursor;
        private Map.Entry<Object, OIdentifiable> nextTxEntry;
        private Map.Entry<Object, OIdentifiable> nextBackedEntry;
        private boolean firstTime;

        public OIndexTxCursor(OIndexCursor txCursor, OIndexCursor backedCursor, boolean ascOrder, OTransactionIndexChanges indexChanges) {
            this.backedCursor = backedCursor;
            this.ascOrder = ascOrder;
            this.indexChanges = indexChanges;
            this.txBetweenIndexCursor = txCursor;
            this.firstTime = true;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.firstTime) {
                this.nextTxEntry = this.txBetweenIndexCursor.nextEntry();
                this.nextBackedEntry = this.backedCursor.nextEntry();
                this.firstTime = false;
            }
            Map.Entry<Object, OIdentifiable> result = null;
            while (result == null && (this.nextTxEntry != null || this.nextBackedEntry != null)) {
                if (this.nextTxEntry == null && this.nextBackedEntry != null) {
                    result = this.nextBackedEntry(this.getPrefetchSize());
                    continue;
                }
                if (this.nextBackedEntry == null && this.nextTxEntry != null) {
                    result = this.nextTxEntry(this.getPrefetchSize());
                    continue;
                }
                if (this.nextTxEntry == null || this.nextBackedEntry == null) continue;
                if (this.ascOrder) {
                    if (ODefaultComparator.INSTANCE.compare(this.nextBackedEntry.getKey(), this.nextTxEntry.getKey()) <= 0) {
                        result = this.nextBackedEntry(this.getPrefetchSize());
                        continue;
                    }
                    result = this.nextTxEntry(this.getPrefetchSize());
                    continue;
                }
                if (ODefaultComparator.INSTANCE.compare(this.nextBackedEntry.getKey(), this.nextTxEntry.getKey()) >= 0) {
                    result = this.nextBackedEntry(this.getPrefetchSize());
                    continue;
                }
                result = this.nextTxEntry(this.getPrefetchSize());
            }
            return result;
        }

        private Map.Entry<Object, OIdentifiable> nextTxEntry(int prefetchSize) {
            Map.Entry<Object, OIdentifiable> result = this.nextTxEntry;
            this.nextTxEntry = this.txBetweenIndexCursor.nextEntry();
            return result;
        }

        private Map.Entry<Object, OIdentifiable> nextBackedEntry(int prefetchSize) {
            Map.Entry result = OIndexTxAwareOneValue.this.calculateTxIndexEntry(this.nextBackedEntry.getKey(), this.nextBackedEntry.getValue(), this.indexChanges);
            this.nextBackedEntry = this.backedCursor.nextEntry();
            return result;
        }
    }

    private class PureTxBetweenIndexBackwardCursor
    extends OIndexAbstractCursor {
        private final OTransactionIndexChanges indexChanges;
        private Object firstKey;
        private Object lastKey;
        private Object nextKey;

        public PureTxBetweenIndexBackwardCursor(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            this.indexChanges = indexChanges;
            fromKey = OIndexTxAwareOneValue.this.enhanceFromCompositeKeyBetweenDesc(fromKey, fromInclusive);
            toKey = OIndexTxAwareOneValue.this.enhanceToCompositeKeyBetweenDesc(toKey, toInclusive);
            this.firstKey = toInclusive ? indexChanges.getCeilingKey(fromKey) : indexChanges.getHigherKey(fromKey);
            this.lastKey = fromInclusive ? indexChanges.getFloorKey(toKey) : indexChanges.getLowerKey(toKey);
            this.nextKey = this.lastKey;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            Map.Entry result;
            if (this.nextKey == null) {
                return null;
            }
            do {
                result = OIndexTxAwareOneValue.this.calculateTxIndexEntry(this.nextKey, null, this.indexChanges);
                this.nextKey = this.indexChanges.getLowerKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.firstKey) >= 0) continue;
                this.nextKey = null;
            } while (result == null && this.nextKey != null);
            return result;
        }
    }

    private class PureTxBetweenIndexForwardCursor
    extends OIndexAbstractCursor {
        private final OTransactionIndexChanges indexChanges;
        private Object firstKey;
        private Object lastKey;
        private Object nextKey;

        public PureTxBetweenIndexForwardCursor(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, OTransactionIndexChanges indexChanges) {
            this.indexChanges = indexChanges;
            fromKey = OIndexTxAwareOneValue.this.enhanceFromCompositeKeyBetweenAsc(fromKey, fromInclusive);
            toKey = OIndexTxAwareOneValue.this.enhanceToCompositeKeyBetweenAsc(toKey, toInclusive);
            this.firstKey = toInclusive ? indexChanges.getCeilingKey(fromKey) : indexChanges.getHigherKey(fromKey);
            this.lastKey = fromInclusive ? indexChanges.getFloorKey(toKey) : indexChanges.getLowerKey(toKey);
            this.nextKey = this.firstKey;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            Map.Entry result;
            if (this.nextKey == null) {
                return null;
            }
            do {
                result = OIndexTxAwareOneValue.this.calculateTxIndexEntry(this.nextKey, null, this.indexChanges);
                this.nextKey = this.indexChanges.getHigherKey(this.nextKey);
                if (this.nextKey == null || ODefaultComparator.INSTANCE.compare(this.nextKey, this.lastKey) <= 0) continue;
                this.nextKey = null;
            } while (result == null && this.nextKey != null);
            return result;
        }
    }
}

