/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareDictionary;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class OIndexManagerAbstract
extends ODocumentWrapperNoClass
implements OIndexManager,
OCloseable {
    public static final String CONFIG_INDEXES = "indexes";
    public static final String DICTIONARY_NAME = "dictionary";
    protected final Map<String, Map<OMultiKey, Set<OIndex<?>>>> classPropertyIndex = new ConcurrentHashMap();
    protected Map<String, OIndex<?>> indexes = new ConcurrentHashMap();
    protected String defaultClusterName = "index";
    protected String manualClusterName = "manindex";
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean fullCheckpointOnChange = false;

    public OIndexManagerAbstract(ODatabaseDocument iDatabase) {
        super(new ODocument().setTrackingChanges(false));
    }

    @Override
    public boolean isFullCheckpointOnChange() {
        return this.fullCheckpointOnChange;
    }

    @Override
    public void setFullCheckpointOnChange(boolean fullCheckpointOnChange) {
        this.fullCheckpointOnChange = fullCheckpointOnChange;
    }

    @Override
    public OIndexManagerAbstract load() {
        if (!this.autoRecreateIndexesAfterCrash()) {
            this.acquireExclusiveLock();
            try {
                if (OIndexManagerAbstract.getDatabase().getStorage().getConfiguration().indexMgrRecordId == null) {
                    this.create();
                }
                ((ORecordId)this.document.getIdentity()).fromString(OIndexManagerAbstract.getDatabase().getStorage().getConfiguration().indexMgrRecordId);
                super.reload("*:-1 index:0");
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        return this;
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        this.acquireExclusiveLock();
        try {
            Object RET = super.reload();
            return RET;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        OScenarioThreadLocal.executeAsDistributed(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OIndexManagerAbstract.this.acquireExclusiveLock();
                try {
                    for (int retry = 0; retry < 10; ++retry) {
                        try {
                            OIndexManagerAbstract.this.toStream();
                            OIndexManagerAbstract.this.document.save();
                            OIndexManagerAbstract.getDatabase().getStorage().synch();
                            break;
                        }
                        catch (OConcurrentModificationException e) {
                            OIndexManagerAbstract.this.reload(null, true);
                            continue;
                        }
                    }
                    OIndexManagerAbstract.this.document.save();
                    OIndexManagerAbstract.getDatabase().getStorage().synch();
                    Object var1_2 = null;
                    return var1_2;
                }
                finally {
                    OIndexManagerAbstract.this.releaseExclusiveLock();
                }
            }
        });
        return (RET)this;
    }

    @Override
    public void create() {
        this.acquireExclusiveLock();
        try {
            block5: {
                try {
                    this.save("internal");
                }
                catch (Exception e) {
                    if (!ORecordId.isPersistent(this.document.getIdentity().getClusterPosition())) break block5;
                    this.document.getIdentity().reset();
                    this.save("internal");
                }
            }
            OIndexManagerAbstract.getDatabase().getStorage().getConfiguration().indexMgrRecordId = this.document.getIdentity().toString();
            OIndexManagerAbstract.getDatabase().getStorage().getConfiguration().update();
            OIndexFactory factory = OIndexes.getFactory(OClass.INDEX_TYPE.DICTIONARY.toString(), null);
            this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(factory.getLastVersion(), OType.STRING), null, null, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void flush() {
        for (OIndex<?> idx : this.indexes.values()) {
            OIndexInternal<?> indexInternal = idx.getInternal();
            if (indexInternal == null) continue;
            indexInternal.flush();
        }
    }

    @Override
    public Collection<? extends OIndex<?>> getIndexes() {
        Collection<OIndex<?>> rawResult = this.indexes.values();
        ArrayList result = new ArrayList(rawResult.size());
        for (OIndex<?> index : rawResult) {
            result.add(OIndexManagerAbstract.preProcessBeforeReturn(index));
        }
        return result;
    }

    @Override
    public OIndex<?> getIndex(String iName) {
        OIndex<?> index = this.indexes.get(iName.toLowerCase());
        if (index == null) {
            return null;
        }
        return OIndexManagerAbstract.preProcessBeforeReturn(index);
    }

    @Override
    public void addClusterToIndex(String clusterName, String indexName) {
        OIndex<?> index = this.indexes.get(indexName.toLowerCase());
        if (index == null) {
            throw new OIndexException("Index with name " + indexName + " does not exist.");
        }
        if (index.getInternal() == null) {
            throw new OIndexException("Index with name " + indexName + " has no internal presentation.");
        }
        index.getInternal().addCluster(clusterName);
        this.save();
    }

    @Override
    public void removeClusterFromIndex(String clusterName, String indexName) {
        OIndex<?> index = this.indexes.get(indexName.toLowerCase());
        if (index == null) {
            throw new OIndexException("Index with name " + indexName + " does not exist.");
        }
        index.getInternal().removeCluster(clusterName);
        this.save();
    }

    @Override
    public boolean existsIndex(String iName) {
        return this.indexes.containsKey(iName.toLowerCase());
    }

    @Override
    public String getDefaultClusterName() {
        this.acquireSharedLock();
        try {
            String string = this.defaultClusterName;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setDefaultClusterName(String defaultClusterName) {
        this.acquireExclusiveLock();
        try {
            this.defaultClusterName = defaultClusterName;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        OIndex<OIdentifiable> idx;
        this.acquireSharedLock();
        try {
            idx = this.getIndex(DICTIONARY_NAME);
        }
        finally {
            this.releaseSharedLock();
        }
        if (idx == null) {
            idx = this.createDictionaryIfNeeded();
        }
        return new ODictionary<ORecord>(idx);
    }

    @Override
    public ODocument getConfiguration() {
        this.acquireSharedLock();
        try {
            ODocument oDocument = this.getDocument();
            return oDocument;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void close() {
        this.indexes.clear();
        this.classPropertyIndex.clear();
    }

    public OIndexManager setDirty() {
        this.acquireExclusiveLock();
        try {
            this.document.setDirty();
            OIndexManagerAbstract oIndexManagerAbstract = this;
            return oIndexManagerAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, Collection<String> fields) {
        fields = this.normalizeFieldNames(fields);
        OMultiKey multiKey = new OMultiKey(fields);
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
        if (propertyIndex == null || !propertyIndex.containsKey(multiKey)) {
            return Collections.emptySet();
        }
        Set<OIndex<?>> rawResult = propertyIndex.get(multiKey);
        HashSet transactionalResult = new HashSet(rawResult.size());
        for (OIndex<?> index : rawResult) {
            transactionalResult.add(OIndexManagerAbstract.preProcessBeforeReturn(index));
        }
        return transactionalResult;
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, String ... fields) {
        return this.getClassInvolvedIndexes(className, Arrays.asList(fields));
    }

    @Override
    public boolean areIndexed(String className, Collection<String> fields) {
        fields = this.normalizeFieldNames(fields);
        OMultiKey multiKey = new OMultiKey(fields);
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
        if (propertyIndex == null) {
            return false;
        }
        return propertyIndex.containsKey(multiKey) && !propertyIndex.get(multiKey).isEmpty();
    }

    @Override
    public boolean areIndexed(String className, String ... fields) {
        return this.areIndexed(className, Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getClassIndexes(String className) {
        HashSet coll = new HashSet(4);
        this.getClassIndexes(className, coll);
        return coll;
    }

    @Override
    public void getClassIndexes(String className, Collection<OIndex<?>> indexes) {
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
        if (propertyIndex == null) {
            return;
        }
        for (Set<OIndex<?>> propertyIndexes : propertyIndex.values()) {
            for (OIndex<?> index : propertyIndexes) {
                indexes.add(OIndexManagerAbstract.preProcessBeforeReturn(index));
            }
        }
    }

    @Override
    public OIndex<?> getClassIndex(String className, String indexName) {
        className = className.toLowerCase();
        OIndex<?> index = this.indexes.get(indexName = indexName.toLowerCase());
        if (index != null && index.getDefinition() != null && index.getDefinition().getClassName() != null && className.equals(index.getDefinition().getClassName().toLowerCase())) {
            return OIndexManagerAbstract.preProcessBeforeReturn(index);
        }
        return null;
    }

    protected void acquireSharedLock() {
        this.lock.readLock().lock();
    }

    protected void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() {
        OMetadataInternal metadata;
        ODatabaseDocumentInternal databaseRecord = this.getDatabaseIfDefined();
        if (databaseRecord != null && !databaseRecord.isClosed() && (metadata = (OMetadataInternal)databaseRecord.getMetadata()) != null) {
            metadata.makeThreadLocalSchemaSnapshot();
        }
        this.lock.writeLock().lock();
    }

    protected void releaseExclusiveLock() {
        OMetadata metadata;
        this.lock.writeLock().unlock();
        ODatabaseDocumentInternal databaseRecord = this.getDatabaseIfDefined();
        if (databaseRecord != null && !databaseRecord.isClosed() && (metadata = databaseRecord.getMetadata()) != null) {
            ((OMetadataInternal)metadata).clearThreadLocalSchemaSnapshot();
        }
    }

    protected void clearMetadata() {
        this.acquireExclusiveLock();
        try {
            this.indexes.clear();
            this.classPropertyIndex.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    protected ODatabaseDocumentInternal getDatabaseIfDefined() {
        return ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIndexInternal(OIndex<?> index) {
        this.acquireExclusiveLock();
        try {
            this.indexes.put(index.getName().toLowerCase(), index);
            OIndexDefinition indexDefinition = index.getDefinition();
            if (indexDefinition == null || indexDefinition.getClassName() == null) {
                return;
            }
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase());
            propertyIndex = propertyIndex == null ? new HashMap() : new HashMap(propertyIndex);
            int paramCount = indexDefinition.getParamCount();
            for (int i = 1; i <= paramCount; ++i) {
                List<String> fields = indexDefinition.getFields().subList(0, i);
                OMultiKey multiKey = new OMultiKey(this.normalizeFieldNames(fields));
                Set<OIndex<?>> indexSet = propertyIndex.get(multiKey);
                indexSet = indexSet == null ? new HashSet() : new HashSet(indexSet);
                indexSet.add(index);
                propertyIndex.put(multiKey, indexSet);
            }
            this.classPropertyIndex.put(indexDefinition.getClassName().toLowerCase(), OIndexManagerAbstract.copyPropertyMap(propertyIndex));
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected static Map<OMultiKey, Set<OIndex<?>>> copyPropertyMap(Map<OMultiKey, Set<OIndex<?>>> original) {
        HashMap result = new HashMap();
        for (Map.Entry<OMultiKey, Set<OIndex<?>>> entry : original.entrySet()) {
            HashSet indexes = new HashSet(entry.getValue());
            assert (indexes.equals(entry.getValue()));
            result.put(entry.getKey(), Collections.unmodifiableSet(indexes));
        }
        assert (result.equals(original));
        return Collections.unmodifiableMap(result);
    }

    protected List<String> normalizeFieldNames(Collection<String> fieldNames) {
        ArrayList<String> result = new ArrayList<String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            result.add(fieldName.toLowerCase());
        }
        return result;
    }

    protected static OIndex<?> preProcessBeforeReturn(OIndex<?> index) {
        if (!(OIndexManagerAbstract.getDatabase().getStorage() instanceof OStorageProxy)) {
            if (index instanceof OIndexMultiValues) {
                return new OIndexTxAwareMultiValue(OIndexManagerAbstract.getDatabase(), index);
            }
            if (index instanceof OIndexDictionary) {
                return new OIndexTxAwareDictionary(OIndexManagerAbstract.getDatabase(), (OIndex<OIdentifiable>)index);
            }
            if (index instanceof OIndexOneValue) {
                return new OIndexTxAwareOneValue(OIndexManagerAbstract.getDatabase(), (OIndex<OIdentifiable>)index);
            }
        }
        return index;
    }

    private OIndex<?> createDictionaryIfNeeded() {
        this.acquireExclusiveLock();
        try {
            OIndex<?> idx = this.getIndex(DICTIONARY_NAME);
            OIndex<?> oIndex = idx != null ? idx : this.createDictionary();
            return oIndex;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private OIndex<?> createDictionary() {
        OIndexFactory factory = OIndexes.getFactory(OClass.INDEX_TYPE.DICTIONARY.toString(), null);
        return this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(factory.getLastVersion(), OType.STRING), null, null, null);
    }
}

