/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.local.O2QCache;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.util.Map;

public class OEngineLocalPaginated
extends OEngineAbstract {
    public static final String NAME = "plocal";
    private final O2QCache readCache = new O2QCache(this.calculateReadCacheMaxMemory(OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L), OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, true, OGlobalConfiguration.DISK_CACHE_PINNED_PAGES.getValueAsInteger());

    public OEngineLocalPaginated() {
        try {
            this.readCache.registerMBean();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "MBean for read cache cannot be registered", (Throwable)e, new Object[0]);
        }
    }

    private long calculateReadCacheMaxMemory(long cacheSize) {
        return (long)((double)cacheSize * ((double)(100 - OGlobalConfiguration.DISK_WRITE_CACHE_PART.getValueAsInteger()) / 100.0));
    }

    public void changeCacheSize(long cacheSize) {
        this.readCache.changeMaximumAmountOfMemory(this.calculateReadCacheMaxMemory(cacheSize));
    }

    @Override
    public OStorage createStorage(String dbName, Map<String, String> configuration) {
        try {
            return new OLocalPaginatedStorage(dbName, dbName, this.getMode(configuration), this.generateStorageId(), this.readCache);
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on opening database: " + dbName + ". Current location is: " + new File(".").getAbsolutePath(), t, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isShared() {
        return true;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.readCache.clear();
        try {
            this.readCache.unregisterMBean();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "MBean for read cache cannot be unregistered", (Throwable)e, new Object[0]);
        }
    }
}

