/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODocumentFieldVisitor;
import com.orientechnologies.orient.core.db.document.ODocumentFieldWalker;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OJSONReader;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class ODatabaseImport
extends ODatabaseImpExpAbstract {
    public static final String EXPORT_IMPORT_MAP_NAME = "___exportImportRIDMap";
    public static final int IMPORT_RECORD_DUMP_LAP_EVERY_MS = 5000;
    private Map<OPropertyImpl, String> linkedClasses = new HashMap<OPropertyImpl, String>();
    private Map<OClass, List<String>> superClasses = new HashMap<OClass, List<String>>();
    private OJSONReader jsonReader;
    private ORecord record;
    private boolean schemaImported = false;
    private int exporterVersion = -1;
    private ORID schemaRecordId;
    private ORID indexMgrRecordId;
    private boolean deleteRIDMapping = true;
    private OIndex<OIdentifiable> exportImportHashTable;
    private boolean preserveClusterIDs = true;
    private boolean migrateLinks = true;
    private boolean merge = false;
    private boolean rebuildIndexes = true;
    private Set<String> indexesToRebuild = new HashSet<String>();
    private Map<String, String> convertedClassNames = new HashMap<String, String>();

    public ODatabaseImport(ODatabaseDocumentInternal database, String iFileName, OCommandOutputListener iListener) throws IOException {
        super(database, iFileName, iListener);
        FilterInputStream inStream;
        BufferedInputStream bf = new BufferedInputStream(new FileInputStream(this.fileName));
        bf.mark(1024);
        try {
            inStream = new GZIPInputStream((InputStream)bf, 16384);
        }
        catch (Exception e) {
            bf.reset();
            inStream = bf;
        }
        OMurmurHash3HashFunction<OIdentifiable> keyHashFunction = new OMurmurHash3HashFunction<OIdentifiable>();
        keyHashFunction.setValueSerializer(OLinkSerializer.INSTANCE);
        this.jsonReader = new OJSONReader(new InputStreamReader(inStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    public ODatabaseImport(ODatabaseDocumentInternal database, InputStream iStream, OCommandOutputListener iListener) throws IOException {
        super(database, "streaming", iListener);
        this.jsonReader = new OJSONReader(new InputStreamReader(iStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    @Override
    public ODatabaseImport setOptions(String iOptions) {
        super.setOptions(iOptions);
        return this;
    }

    public ODatabaseImport importDatabase() {
        try {
            this.listener.onMessage("\nStarted import of database '" + this.database.getURL() + "' from " + this.fileName + "...");
            long time = System.currentTimeMillis();
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            this.database.setMVCC(false);
            this.database.setValidationEnabled(false);
            this.database.setStatus(ODatabase.STATUS.IMPORTING);
            for (OIndex<?> index : this.database.getMetadata().getIndexManager().getIndexes()) {
                if (!index.isAutomatic()) continue;
                this.indexesToRebuild.add(index.getName().toLowerCase());
            }
            if (!this.merge) {
                this.removeDefaultNonSecurityClasses();
            }
            while (this.jsonReader.hasNext() && this.jsonReader.lastChar() != '}') {
                String tag = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                if (tag.equals("info")) {
                    this.importInfo();
                    continue;
                }
                if (tag.equals("clusters")) {
                    this.importClusters();
                    continue;
                }
                if (tag.equals("schema")) {
                    this.importSchema();
                    continue;
                }
                if (tag.equals("records")) {
                    this.importRecords();
                    continue;
                }
                if (tag.equals("indexes")) {
                    this.importIndexes();
                    continue;
                }
                if (!tag.equals("manualIndexes")) continue;
                this.importManualIndexes();
            }
            if (this.rebuildIndexes) {
                this.rebuildIndexes();
            }
            this.database.getMetadata().reload();
            this.database.getStorage().synch();
            this.database.setStatus(ODatabase.STATUS.OPEN);
            if (this.isDeleteRIDMapping()) {
                this.removeExportImportRIDsMap();
            }
            this.listener.onMessage("\n\nDatabase import completed in " + (System.currentTimeMillis() - time) + " ms");
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            writer.append("Error on database import happened just before line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber() + "\n");
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            this.listener.onMessage(writer.toString());
            try {
                writer.close();
            }
            catch (IOException e1) {
                throw new ODatabaseExportException("Error on importing database '" + this.database.getName() + "' from file: " + this.fileName, e1);
            }
            throw new ODatabaseExportException("Error on importing database '" + this.database.getName() + "' from file: " + this.fileName, e);
        }
        finally {
            this.close();
        }
        return this;
    }

    public void rebuildIndexes() {
        this.database.getMetadata().getIndexManager().reload();
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        this.listener.onMessage("\nRebuild of stale indexes...");
        for (String indexName : this.indexesToRebuild) {
            if (indexManager.getIndex(indexName) == null) {
                this.listener.onMessage("\nIndex " + indexName + " is skipped because it is absent in imported DB.");
                continue;
            }
            this.listener.onMessage("\nStart rebuild index " + indexName);
            this.database.command(new OCommandSQL("rebuild index " + indexName)).execute(new Object[0]);
            this.listener.onMessage("\nRebuild  of index " + indexName + " is completed.");
        }
        this.listener.onMessage("\nStale indexes were rebuilt...");
    }

    public ODatabaseImport removeExportImportRIDsMap() {
        this.listener.onMessage("\nDeleting RID Mapping table...");
        if (this.exportImportHashTable != null) {
            this.database.command(new OCommandSQL("drop index ___exportImportRIDMap"));
            this.exportImportHashTable = null;
        }
        this.listener.onMessage("OK\n");
        return this;
    }

    public void close() {
        this.database.declareIntent(null);
    }

    public boolean isMigrateLinks() {
        return this.migrateLinks;
    }

    public void setMigrateLinks(boolean migrateLinks) {
        this.migrateLinks = migrateLinks;
    }

    public boolean isRebuildIndexes() {
        return this.rebuildIndexes;
    }

    public void setRebuildIndexes(boolean rebuildIndexes) {
        this.rebuildIndexes = rebuildIndexes;
    }

    public boolean isPreserveClusterIDs() {
        return this.preserveClusterIDs;
    }

    public void setPreserveClusterIDs(boolean preserveClusterIDs) {
        this.preserveClusterIDs = preserveClusterIDs;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public boolean isDeleteRIDMapping() {
        return this.deleteRIDMapping;
    }

    public void setDeleteRIDMapping(boolean deleteRIDMapping) {
        this.deleteRIDMapping = deleteRIDMapping;
    }

    @Override
    protected void parseSetting(String option, List<String> items) {
        if (option.equalsIgnoreCase("-deleteRIDMapping")) {
            this.deleteRIDMapping = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-preserveClusterIDs")) {
            this.preserveClusterIDs = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-merge")) {
            this.merge = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-migrateLinks")) {
            this.migrateLinks = Boolean.parseBoolean(items.get(0));
        } else if (option.equalsIgnoreCase("-rebuildIndexes")) {
            this.rebuildIndexes = Boolean.parseBoolean(items.get(0));
        } else {
            super.parseSetting(option, items);
        }
    }

    protected void removeDefaultClusters() {
        this.listener.onMessage("\nWARN: Exported database does not support manual index separation. Manual index cluster will be dropped.");
        this.database.dropCluster("manindex", true);
        OSchema schema = this.database.getMetadata().getSchema();
        if (schema.existsClass("OUser")) {
            schema.dropClass("OUser");
        }
        if (schema.existsClass("ORole")) {
            schema.dropClass("ORole");
        }
        if (schema.existsClass("ORestricted")) {
            schema.dropClass("ORestricted");
        }
        if (schema.existsClass("OFunction")) {
            schema.dropClass("OFunction");
        }
        if (schema.existsClass("ORIDs")) {
            schema.dropClass("ORIDs");
        }
        if (schema.existsClass("OTriggered")) {
            schema.dropClass("OTriggered");
        }
        schema.save();
        this.database.dropCluster("default", true);
        this.database.getStorage().setDefaultClusterId(this.database.addCluster("default", new Object[0]));
        new ODocument().save("default");
        this.database.getMetadata().getSecurity().create();
    }

    private void removeDefaultNonSecurityClasses() {
        this.listener.onMessage("\nNon merge mode (-merge=false): removing all default non security classes");
        OSchema schema = this.database.getMetadata().getSchema();
        Collection<OClass> classes = schema.getClasses();
        OClass orole = schema.getClass("ORole");
        OClass ouser = schema.getClass("OUser");
        OClass oidentity = schema.getClass("OIdentity");
        HashMap<String, OClass> classesToDrop = new HashMap<String, OClass>();
        for (OClass dbClass : classes) {
            String className = dbClass.getName();
            if (dbClass.isSuperClassOf(orole) || dbClass.isSuperClassOf(ouser) || dbClass.isSuperClassOf(oidentity)) continue;
            classesToDrop.put(className, dbClass);
        }
        int removedClasses = 0;
        while (!classesToDrop.isEmpty()) {
            ArrayList<String> classesReadyToDrop = new ArrayList<String>();
            for (String className : classesToDrop.keySet()) {
                boolean isSuperClass = false;
                block3: for (OClass dbClass : classesToDrop.values()) {
                    List<OClass> parentClasses = dbClass.getSuperClasses();
                    if (parentClasses == null) continue;
                    for (OClass parentClass : parentClasses) {
                        if (!className.equalsIgnoreCase(parentClass.getName())) continue;
                        isSuperClass = true;
                        continue block3;
                    }
                }
                if (isSuperClass) continue;
                ((AbstractList)classesReadyToDrop).add(className);
            }
            for (String className : classesReadyToDrop) {
                schema.dropClass(className);
                classesToDrop.remove(className);
                ++removedClasses;
                this.listener.onMessage("\n- Class " + className + " was removed.");
            }
        }
        schema.save();
        schema.reload();
        this.listener.onMessage("\nRemoved " + removedClasses + " classes.");
    }

    private void importInfo() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database info...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            if (fieldName.equals("exporter-version")) {
                this.exporterVersion = this.jsonReader.readInteger(OJSONReader.NEXT_IN_OBJECT);
                continue;
            }
            if (fieldName.equals("schemaRecordId")) {
                this.schemaRecordId = new ORecordId(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                continue;
            }
            if (fieldName.equals("indexMgrRecordId")) {
                this.indexMgrRecordId = new ORecordId(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                continue;
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        if (this.schemaRecordId == null) {
            this.schemaRecordId = new ORecordId(this.database.getStorage().getConfiguration().schemaRecordId);
        }
        if (this.indexMgrRecordId == null) {
            this.indexMgrRecordId = new ORecordId(this.database.getStorage().getConfiguration().indexMgrRecordId);
        }
        this.listener.onMessage("OK");
    }

    private void importManualIndexes() throws IOException, ParseException {
        this.listener.onMessage("\nImporting manual index entries...");
        ODocument doc = new ODocument();
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        int n = 0;
        do {
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            if (indexName == null || indexName.length() == 0) {
                return;
            }
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            OIndex<?> index = this.database.getMetadata().getIndexManager().getIndex(indexName);
            long tot = 0L;
            this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
            do {
                OIdentifiable newRid;
                String value;
                if ((value = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY).trim()).isEmpty() || indexName.equalsIgnoreCase(EXPORT_IMPORT_MAP_NAME)) continue;
                doc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, doc, null);
                doc.setLazyLoad(false);
                OIdentifiable oldRid = (OIdentifiable)doc.field("rid");
                if (!((Boolean)doc.field("binary")).booleanValue()) {
                    newRid = this.exportImportHashTable != null ? this.exportImportHashTable.get(oldRid) : oldRid;
                    index.put(doc.field("key"), newRid != null ? newRid.getIdentity() : oldRid.getIdentity());
                } else {
                    ORuntimeKeyIndexDefinition runtimeKeyIndexDefinition = (ORuntimeKeyIndexDefinition)index.getDefinition();
                    OBinarySerializer binarySerializer = runtimeKeyIndexDefinition.getSerializer();
                    newRid = this.exportImportHashTable != null ? this.exportImportHashTable.get(doc.field("rid")).getIdentity() : (OIdentifiable)doc.field("rid");
                    index.put(binarySerializer.deserialize((byte[])doc.field("key"), 0), newRid != null ? newRid : oldRid);
                }
                ++tot;
            } while (this.jsonReader.lastChar() == ',');
            if (index != null) {
                this.listener.onMessage("OK (" + tot + " entries)");
                ++n;
            } else {
                this.listener.onMessage("ERR, the index wasn't found in configuration");
            }
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        } while (this.jsonReader.lastChar() == ',');
        this.listener.onMessage("\nDone. Imported " + String.format("%,d", n) + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private void importSchema() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database schema...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        int schemaVersion = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"version\"").readNumber(OJSONReader.ANY_NUMBER, true);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        if (this.jsonReader.getValue().equals("\"globalProperties\"")) {
            this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
            do {
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"");
                String name = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"global-id\"");
                String id = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"");
                String type = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            } while (this.jsonReader.lastChar() == ',');
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        }
        this.jsonReader.checkContent("\"classes\"").readNext(OJSONReader.BEGIN_COLLECTION);
        long classImported = 0L;
        try {
            do {
                OClassImpl cls;
                int classDefClusterId;
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                Iterator<Map.Entry<OPropertyImpl, String>> className = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
                String string = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                if (string.equals("\"id\"")) {
                    String string3 = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
                    string3 = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                }
                if (this.jsonReader.isContent("\"default-cluster-id\"")) {
                    String string4 = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    classDefClusterId = Integer.parseInt(string4);
                } else {
                    classDefClusterId = this.database.getDefaultClusterId();
                }
                String classClusterIds = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"cluster-ids\"").readString(OJSONReader.END_COLLECTION, true).trim();
                this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                if (((String)((Object)className)).contains(".")) {
                    String newClassName = ((String)((Object)className)).replace('.', '_');
                    this.convertedClassNames.put((String)((Object)className), newClassName);
                    this.listener.onMessage("\nWARNING: class '" + (String)((Object)className) + "' has been renamed in '" + newClassName + "'\n");
                    className = newClassName;
                }
                if ((cls = (OClassImpl)this.database.getMetadata().getSchema().getClass((String)((Object)className))) != null) {
                    if (cls.getDefaultClusterId() != classDefClusterId) {
                        cls.setDefaultClusterId(classDefClusterId);
                    }
                } else {
                    cls = (OClassImpl)this.database.getMetadata().getSchema().createClass((String)((Object)className), classDefClusterId);
                }
                if (classClusterIds != null) {
                    classClusterIds = classClusterIds.substring(1, classClusterIds.length() - 1);
                    for (int i : OStringSerializerHelper.splitIntArray(classClusterIds)) {
                        if (i == -1) continue;
                        cls.addClusterId(i);
                    }
                }
                while (this.jsonReader.lastChar() == ',') {
                    this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
                    String value = this.jsonReader.getValue();
                    if (value.equals("\"strictMode\"")) {
                        cls.setStrictMode(this.jsonReader.readBoolean(OJSONReader.NEXT_IN_OBJECT));
                        continue;
                    }
                    if (value.equals("\"abstract\"")) {
                        cls.setAbstract(this.jsonReader.readBoolean(OJSONReader.NEXT_IN_OBJECT));
                        continue;
                    }
                    if (value.equals("\"oversize\"")) {
                        String oversize = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setOverSize(Float.parseFloat(oversize));
                        continue;
                    }
                    if (value.equals("\"strictMode\"")) {
                        String strictMode = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setStrictMode(Boolean.parseBoolean(strictMode));
                        continue;
                    }
                    if (value.equals("\"short-name\"")) {
                        String shortName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        if (cls.getName().equalsIgnoreCase(shortName)) continue;
                        cls.setShortName(shortName);
                        continue;
                    }
                    if (value.equals("\"super-class\"")) {
                        String classSuper = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        ArrayList<String> superClassNames = new ArrayList<String>();
                        superClassNames.add(classSuper);
                        this.superClasses.put(cls, superClassNames);
                        continue;
                    }
                    if (value.equals("\"super-classes\"")) {
                        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
                        ArrayList<String> superClassNames = new ArrayList<String>();
                        while (this.jsonReader.lastChar() != ']') {
                            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                            String clsName = this.jsonReader.getValue();
                            superClassNames.add(OStringSerializerHelper.getStringContent(clsName));
                        }
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                        this.superClasses.put(cls, superClassNames);
                        continue;
                    }
                    if (value.equals("\"properties\"")) {
                        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
                        while (this.jsonReader.lastChar() != ']') {
                            this.importProperty(cls);
                            if (this.jsonReader.lastChar() != '}') continue;
                            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        }
                        this.jsonReader.readNext(OJSONReader.END_OBJECT);
                        continue;
                    }
                    if (value.equals("\"customFields\"")) {
                        Map<String, String> customFields = this.importCustomFields();
                        for (Map.Entry<String, String> entry : customFields.entrySet()) {
                            cls.setCustom(entry.getKey(), entry.getValue());
                        }
                        continue;
                    }
                    if (!value.equals("\"cluster-selection\"")) continue;
                    cls.setClusterSelection(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                }
                ++classImported;
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            } while (this.jsonReader.lastChar() == ',');
            for (Map.Entry entry : this.superClasses.entrySet()) {
                for (String s : (List)entry.getValue()) {
                    OClass superClass = this.database.getMetadata().getSchema().getClass(s);
                    if (((OClass)entry.getKey()).getSuperClasses().contains(superClass)) continue;
                    ((OClass)entry.getKey()).addSuperClass(superClass);
                }
            }
            for (Map.Entry<OPropertyImpl, String> entry : this.linkedClasses.entrySet()) {
                entry.getKey().setLinkedClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            this.database.getMetadata().getSchema().save();
            if (this.exporterVersion < 11) {
                OClass role = this.database.getMetadata().getSchema().getClass("ORole");
                role.dropProperty("rules");
            }
            this.listener.onMessage("OK (" + classImported + " classes)");
            this.schemaImported = true;
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on importing schema", (Throwable)e, new Object[0]);
            this.listener.onMessage("ERROR (" + classImported + " entries): " + e);
        }
    }

    private void importProperty(OClass iClass) throws IOException, ParseException {
        this.jsonReader.readNext(OJSONReader.NEXT_OBJ_IN_ARRAY);
        if (this.jsonReader.lastChar() == ']') {
            return;
        }
        String propName = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
        String next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        if (next.equals("\"id\"")) {
            next = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
            next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        }
        next = this.jsonReader.checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
        OType type = OType.valueOf(next);
        String value = null;
        String min = null;
        String max = null;
        String linkedClass = null;
        OType linkedType = null;
        boolean mandatory = false;
        boolean readonly = false;
        boolean notNull = false;
        String collate = null;
        Map<String, String> customFields = null;
        while (this.jsonReader.lastChar() == ',') {
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
            String attrib = this.jsonReader.getValue();
            if (!attrib.equals("\"customFields\"")) {
                value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            }
            if (attrib.equals("\"min\"")) {
                min = value;
                continue;
            }
            if (attrib.equals("\"max\"")) {
                max = value;
                continue;
            }
            if (attrib.equals("\"linked-class\"")) {
                linkedClass = value;
                continue;
            }
            if (attrib.equals("\"mandatory\"")) {
                mandatory = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"readonly\"")) {
                readonly = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"not-null\"")) {
                notNull = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"linked-type\"")) {
                linkedType = OType.valueOf(value);
                continue;
            }
            if (attrib.equals("\"collate\"")) {
                collate = value;
                continue;
            }
            if (!attrib.equals("\"customFields\"")) continue;
            customFields = this.importCustomFields();
        }
        OPropertyImpl prop = (OPropertyImpl)iClass.getProperty(propName);
        if (prop == null) {
            prop = (OPropertyImpl)iClass.createProperty(propName, type);
        }
        prop.setMandatory(mandatory);
        prop.setReadonly(readonly);
        prop.setNotNull(notNull);
        if (min != null) {
            prop.setMin(min);
        }
        if (max != null) {
            prop.setMax(max);
        }
        if (linkedClass != null) {
            this.linkedClasses.put(prop, linkedClass);
        }
        if (linkedType != null) {
            prop.setLinkedType(linkedType);
        }
        if (collate != null) {
            prop.setCollate(value);
        }
        if (customFields != null) {
            for (Map.Entry entry : customFields.entrySet()) {
                prop.setCustom((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private Map<String, String> importCustomFields() throws ParseException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String key = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            result.put(key, value);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long importClusters() throws ParseException, IOException {
        this.listener.onMessage("\nImporting clusters...");
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        boolean makeFullCheckPointAfterClusterCreation = false;
        if (this.database.getStorage() instanceof OLocalPaginatedStorage) {
            makeFullCheckPointAfterClusterCreation = ((OLocalPaginatedStorage)this.database.getStorage()).isMakeFullCheckPointAfterClusterCreate();
            ((OLocalPaginatedStorage)this.database.getStorage()).disableFullCheckPointAfterClusterCreate();
        }
        boolean recreateManualIndex = false;
        if (this.exporterVersion <= 4) {
            this.removeDefaultClusters();
            recreateManualIndex = true;
        }
        HashSet<String> indexesToRebuild = new HashSet<String>();
        ORecordId rid = null;
        while (this.jsonReader.lastChar() != ']') {
            int clusterId;
            int id;
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            Object name = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
            if (((String)name).length() == 0) {
                name = null;
            }
            if (name != null) {
                if (this.includeClusters != null) {
                    if (!this.includeClusters.contains(name)) {
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        continue;
                    }
                } else if (this.excludeClusters != null && this.excludeClusters.contains(name)) {
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    continue;
                }
            }
            if (this.exporterVersion < 9) {
                id = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"id\"").readInteger(OJSONReader.COMMA_SEPARATOR);
                String string = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
            } else {
                id = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"id\"").readInteger(OJSONReader.NEXT_IN_OBJECT);
            }
            String type = this.jsonReader.lastChar() == ',' ? this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT) : "PHYSICAL";
            rid = this.jsonReader.lastChar() == ',' ? new ORecordId(this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"rid\"").readString(OJSONReader.NEXT_IN_OBJECT)) : null;
            this.listener.onMessage("\n- Creating cluster " + (name != null ? "'" + (String)name + "'" : "NULL") + "...");
            int n = clusterId = name != null ? this.database.getClusterIdByName((String)name) : -1;
            if (clusterId == -1) {
                if (!this.preserveClusterIDs) {
                    clusterId = this.database.addCluster((String)name, new Object[0]);
                } else {
                    clusterId = this.database.addCluster((String)name, id, (Object[])null);
                    assert (clusterId == id);
                }
            }
            if (clusterId != id) {
                if (!this.preserveClusterIDs) {
                    if (this.database.countClusterElements(clusterId - 1) != 0L) throw new OConfigurationException("Imported cluster '" + (String)name + "' has id=" + clusterId + " different from the original: " + id + ". To continue the import drop the cluster '" + this.database.getClusterNameById(clusterId - 1) + "' that has " + this.database.countClusterElements(clusterId - 1) + " records");
                    this.listener.onMessage("Found previous version: migrating old clusters...");
                    this.database.dropCluster((String)name, true);
                    this.database.addCluster("temp_" + clusterId, null);
                    clusterId = this.database.addCluster((String)name, new Object[0]);
                } else {
                    this.database.dropCluster(clusterId, false);
                    this.database.addCluster((String)name, id, (Object[])null);
                }
            }
            if (!(name == null || ((String)name).equalsIgnoreCase("manindex") || ((String)name).equalsIgnoreCase("internal") || ((String)name).equalsIgnoreCase("index"))) {
                if (!this.merge) {
                    this.database.command(new OCommandSQL("truncate cluster " + (String)name)).execute(new Object[0]);
                }
                for (OIndex<?> existingIndex : this.database.getMetadata().getIndexManager().getIndexes()) {
                    if (!existingIndex.getClusters().contains(name)) continue;
                    indexesToRebuild.add(existingIndex.getName());
                }
            }
            this.listener.onMessage("OK, assigned id=" + clusterId);
            ++total;
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.listener.onMessage("\nRebuilding indexes of truncated clusters ...");
        for (final String indexName : indexesToRebuild) {
            this.database.getMetadata().getIndexManager().getIndex(indexName).rebuild(new OProgressListener(){
                private long last = 0L;

                @Override
                public void onBegin(Object iTask, long iTotal, Object metadata) {
                    ODatabaseImport.this.listener.onMessage("\n- Cluster content was updated: rebuilding index '" + indexName + "'...");
                }

                @Override
                public boolean onProgress(Object iTask, long iCounter, float iPercent) {
                    long now = System.currentTimeMillis();
                    if (this.last == 0L) {
                        this.last = now;
                    } else if (now - this.last > 1000L) {
                        ODatabaseImport.this.listener.onMessage(String.format("\nIndex '%s' is rebuilding (%.2f/100)", indexName, Float.valueOf(iPercent)));
                        this.last = now;
                    }
                    return true;
                }

                @Override
                public void onCompletition(Object iTask, boolean iSucceed) {
                    ODatabaseImport.this.listener.onMessage(" Index " + indexName + " was successfully rebuilt.");
                }
            });
        }
        this.listener.onMessage("\nDone " + indexesToRebuild.size() + " indexes were rebuilt.");
        if (recreateManualIndex) {
            this.database.addCluster("manindex", new Object[0]);
            this.database.getMetadata().getIndexManager().create();
            this.listener.onMessage("\nManual index cluster was recreated.");
        }
        this.listener.onMessage("\nDone. Imported " + total + " clusters");
        if (this.database.load(new ORecordId(this.database.getStorage().getConfiguration().indexMgrRecordId)) == null) {
            ODocument indexDocument = new ODocument();
            indexDocument.save("internal");
            this.database.getStorage().getConfiguration().indexMgrRecordId = indexDocument.getIdentity().toString();
            this.database.getStorage().getConfiguration().update();
        }
        if (!(this.database.getStorage() instanceof OLocalPaginatedStorage) || !makeFullCheckPointAfterClusterCreation) return total;
        ((OLocalPaginatedStorage)this.database.getStorage()).enableFullCheckPointAfterClusterCreate();
        return total;
    }

    private long importRecords() throws Exception {
        long total = 0L;
        this.database.getMetadata().getIndexManager().dropIndex(EXPORT_IMPORT_MAP_NAME);
        OIndexFactory factory = OIndexes.getFactory(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString(), null);
        this.exportImportHashTable = this.database.getMetadata().getIndexManager().createIndex(EXPORT_IMPORT_MAP_NAME, OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString(), new OSimpleKeyIndexDefinition(factory.getLastVersion(), OType.LINK), null, null, null);
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        long totalRecords = 0L;
        this.listener.onMessage("\n\nImporting records...");
        ORID lastRid = new ORecordId();
        long begin = System.currentTimeMillis();
        long lastLapRecords = 0L;
        long last = begin;
        HashSet<String> involvedClusters = new HashSet<String>();
        while (this.jsonReader.lastChar() != ']') {
            ORID rid = this.importRecord();
            if (rid != null) {
                long now;
                ++lastLapRecords;
                ++totalRecords;
                if (rid.getClusterId() != lastRid.getClusterId() || involvedClusters.isEmpty()) {
                    involvedClusters.add(this.database.getClusterNameById(rid.getClusterId()));
                }
                if ((now = System.currentTimeMillis()) - last > 5000L) {
                    ArrayList sortedClusters = new ArrayList(involvedClusters);
                    Collections.sort(sortedClusters);
                    this.listener.onMessage(String.format("\n- Imported %,d records into clusters: %s. Total records imported so far: %,d (%,.2f/sec)", lastLapRecords, sortedClusters, totalRecords, Float.valueOf((float)lastLapRecords * 1000.0f / 5000.0f)));
                    last = now;
                    lastLapRecords = 0L;
                    involvedClusters.clear();
                }
                lastRid = rid;
            }
            this.record = null;
        }
        if (this.migrateLinks) {
            this.migrateLinksInImportedDocuments();
        }
        this.listener.onMessage(String.format("\n\nDone. Imported %,d records in %,.2f secs\n", totalRecords, Float.valueOf((float)(System.currentTimeMillis() - begin) / 1000.0f)));
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        return total;
    }

    private ORID importRecord() throws Exception {
        String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
        while (!value.isEmpty() && value.charAt(0) != '{') {
            value = value.substring(1);
        }
        this.record = null;
        try {
            String value1;
            block31: {
                try {
                    this.record = ORecordSerializerJSON.INSTANCE.fromString(value, this.record, null);
                }
                catch (OSerializationException e) {
                    int pos;
                    if (!(e.getCause() instanceof OSchemaException) || (pos = value.indexOf("\"@class\":\"")) <= -1) break block31;
                    int end = value.indexOf("\"", pos + "\"@class\":\"".length() + 1);
                    value1 = value.substring(0, pos + "\"@class\":\"".length());
                    String clsName = value.substring(pos + "\"@class\":\"".length(), end);
                    String value2 = value.substring(end);
                    String newClassName = this.convertedClassNames.get(clsName);
                    value = value1 + newClassName + value2;
                    this.record = ORecordSerializerJSON.INSTANCE.fromString(value, this.record, null);
                }
            }
            if (this.schemaImported && this.record.getIdentity().equals(this.schemaRecordId)) {
                ORID e = null;
                return e;
            }
            if (this.includeClusters != null) {
                if (!this.includeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) {
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    ORID e = null;
                    return e;
                }
            } else if (this.excludeClusters != null && this.excludeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) {
                ORID e = null;
                return e;
            }
            if (this.record.getIdentity().getClusterId() == 0 && this.record.getIdentity().getClusterPosition() == 1L) {
                ORID e = null;
                return e;
            }
            if (this.exporterVersion >= 3) {
                int oridsId = this.database.getClusterIdByName("ORIDs");
                int indexId = this.database.getClusterIdByName("index");
                if (this.record.getIdentity().getClusterId() == indexId || this.record.getIdentity().getClusterId() == oridsId) {
                    ORID end = null;
                    return end;
                }
            }
            int manualIndexCluster = this.database.getClusterIdByName("manindex");
            int internalCluster = this.database.getClusterIdByName("internal");
            int indexCluster = this.database.getClusterIdByName("index");
            if (this.exporterVersion >= 4 && this.record.getIdentity().getClusterId() == manualIndexCluster) {
                value1 = null;
                return value1;
            }
            if (this.record.getIdentity().equals(this.indexMgrRecordId)) {
                value1 = null;
                return value1;
            }
            ORID rid = this.record.getIdentity();
            int clusterId = rid.getClusterId();
            if (clusterId != manualIndexCluster && clusterId != internalCluster && clusterId != indexCluster) {
                this.record.getRecordVersion().copyFrom(OVersionFactory.instance().createVersion());
                this.record.setDirty();
                ORecordInternal.setIdentity(this.record, new ORecordId());
                if (!this.preserveRids && this.record instanceof ODocument && ODocumentInternal.getImmutableSchemaClass((ODocument)this.record) != null) {
                    this.record.save();
                } else {
                    this.record.save(this.database.getClusterNameById(clusterId));
                }
                if (!rid.equals(this.record.getIdentity())) {
                    this.exportImportHashTable.put(rid, this.record.getIdentity());
                }
            }
        }
        catch (Exception t) {
            if (this.record != null) {
                OLogManager.instance().error((Object)this, "Error importing record " + this.record.getIdentity() + ". Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber(), new Object[0]);
            } else {
                OLogManager.instance().error((Object)this, "Error importing record. Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber(), new Object[0]);
            }
            throw t;
        }
        finally {
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        }
        return this.record.getIdentity();
    }

    private void importIndexes() throws IOException, ParseException {
        this.listener.onMessage("\n\nImporting indexes ...");
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        int n = 0;
        while (this.jsonReader.lastChar() != ']') {
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            String blueprintsIndexClass = null;
            String indexName = null;
            String indexType = null;
            String indexAlgorithm = null;
            Set<Object> clustersToIndex = new HashSet();
            OIndexDefinition indexDefinition = null;
            ODocument metadata = null;
            while (this.jsonReader.lastChar() != '}') {
                String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                if (fieldName.equals("name")) {
                    indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("type")) {
                    indexType = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("algorithm")) {
                    indexAlgorithm = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("clustersToIndex")) {
                    clustersToIndex = this.importClustersToIndex();
                    continue;
                }
                if (fieldName.equals("definition")) {
                    indexDefinition = this.importIndexDefinition();
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("metadata")) {
                    String jsonMetadata = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
                    metadata = new ODocument().fromJSON(jsonMetadata);
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (!fieldName.equals("blueprintsIndexClass")) continue;
                blueprintsIndexClass = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            }
            if (indexName == null) {
                throw new IllegalArgumentException("Index name is missing");
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            if (indexName.equalsIgnoreCase(EXPORT_IMPORT_MAP_NAME)) continue;
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            indexManager.dropIndex(indexName);
            this.indexesToRebuild.remove(indexName.toLowerCase());
            int[] clusterIdsToIndex = new int[clustersToIndex.size()];
            int i = 0;
            for (String string : clustersToIndex) {
                clusterIdsToIndex[i] = this.database.getClusterIdByName(string);
                ++i;
            }
            OIndex<?> index = indexManager.createIndex(indexName, indexType, indexDefinition, clusterIdsToIndex, null, metadata, indexAlgorithm);
            if (blueprintsIndexClass != null) {
                ODocument oDocument = index.getConfiguration();
                oDocument.field("blueprintsIndexClass", blueprintsIndexClass);
                indexManager.save();
            }
            ++n;
            this.listener.onMessage("OK");
        }
        this.listener.onMessage("\nDone. Created " + n + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private Set<String> importClustersToIndex() throws IOException, ParseException {
        HashSet<String> clustersToIndex = new HashSet<String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        while (this.jsonReader.lastChar() != ']') {
            String clusterToIndex = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            clustersToIndex.add(clusterToIndex);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return clustersToIndex;
    }

    private OIndexDefinition importIndexDefinition() throws IOException, ParseException {
        OIndexDefinition indexDefinition;
        this.jsonReader.readString(OJSONReader.BEGIN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String className = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
        ODocument indexDefinitionDoc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, null, null);
        try {
            Class<?> indexDefClass = Class.forName(className);
            indexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            indexDefinition.fromStream(indexDefinitionDoc);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
        return indexDefinition;
    }

    private void migrateLinksInImportedDocuments() throws IOException {
        long begin;
        this.listener.onMessage("\n\nStarted migration of links (-migrateLinks=true). Links are going to be updated according to new RIDs:");
        long last = begin = System.currentTimeMillis();
        long documentsLastLap = 0L;
        long totalDocuments = 0L;
        Collection<String> clusterNames = this.database.getClusterNames();
        for (String clusterName : clusterNames) {
            if ("index".equals(clusterName) || "internal".equals(clusterName) || "manindex".equals(clusterName)) continue;
            long documents = 0L;
            String prefix = "";
            this.listener.onMessage("\n- Cluster " + clusterName + "...");
            int clusterId = this.database.getClusterIdByName(clusterName);
            long clusterRecords = this.database.countClusterElements(clusterId);
            OStorage storage = this.database.getStorage();
            OPhysicalPosition[] positions = storage.ceilingPhysicalPositions(clusterId, new OPhysicalPosition(0L));
            while (positions.length > 0) {
                for (OPhysicalPosition position : positions) {
                    ORecord record = (ORecord)this.database.load(new ORecordId(clusterId, position.clusterPosition));
                    if (!(record instanceof ODocument)) continue;
                    ODocument document = (ODocument)record;
                    this.rewriteLinksInDocument(document);
                    ++documents;
                    ++documentsLastLap;
                    ++totalDocuments;
                    long now = System.currentTimeMillis();
                    if (now - last <= 5000L) continue;
                    this.listener.onMessage(String.format("\n--- Migrated %,d of %,d records (%,.2f/sec)", documents, clusterRecords, Float.valueOf((float)documentsLastLap * 1000.0f / 5000.0f)));
                    last = now;
                    documentsLastLap = 0L;
                    prefix = "\n---";
                }
                positions = storage.higherPhysicalPositions(clusterId, positions[positions.length - 1]);
            }
            this.listener.onMessage(String.format("%s Completed migration of %,d records in current cluster", prefix, documents));
        }
        this.listener.onMessage(String.format("\nTotal links updated: %,d", totalDocuments));
    }

    private void rewriteLinksInDocument(ODocument document) {
        ODatabaseImport.rewriteLinksInDocument(document, this.exportImportHashTable);
        document.save();
    }

    protected static void rewriteLinksInDocument(ODocument document, OIndex<OIdentifiable> rewrite) {
        LinkConverter.INSTANCE.setExportImportHashTable(rewrite);
        LinksRewriter rewriter = new LinksRewriter();
        ODocumentFieldWalker documentFieldWalker = new ODocumentFieldWalker();
        documentFieldWalker.walkDocument(document, rewriter);
    }

    private static final class LinkConverter
    implements ValuesConverter<OIdentifiable> {
        public static final LinkConverter INSTANCE = new LinkConverter();
        private OIndex<OIdentifiable> exportImportHashTable;

        private LinkConverter() {
        }

        @Override
        public OIdentifiable convert(OIdentifiable value) {
            ORID rid = value.getIdentity();
            if (!rid.isPersistent()) {
                return value;
            }
            OIdentifiable newRid = this.exportImportHashTable.get(rid);
            if (newRid == null) {
                return value;
            }
            return newRid.getIdentity();
        }

        public void setExportImportHashTable(OIndex<OIdentifiable> exportImportHashTable) {
            this.exportImportHashTable = exportImportHashTable;
        }
    }

    private static final class MapConverter
    extends AbstractCollectionConverter<Map> {
        public static final MapConverter INSTANCE = new MapConverter();

        private MapConverter() {
        }

        @Override
        public Map convert(Map value) {
            final HashMap result = new HashMap();
            boolean updated = false;
            final class MapResultCallback
            implements AbstractCollectionConverter.ResultCallback {
                private Object key;

                MapResultCallback() {
                }

                @Override
                public void add(Object item) {
                    result.put(this.key, item);
                }

                public void setKey(Object key) {
                    this.key = key;
                }
            }
            MapResultCallback callback = new MapResultCallback();
            for (Map.Entry entry : value.entrySet()) {
                callback.setKey(entry.getKey());
                updated = this.convertSingleValue(entry.getValue(), callback, updated);
            }
            if (updated) {
                return result;
            }
            return value;
        }
    }

    private static final class RidBagConverter
    extends AbstractCollectionConverter<ORidBag> {
        public static final RidBagConverter INSTANCE = new RidBagConverter();

        private RidBagConverter() {
        }

        @Override
        public ORidBag convert(ORidBag value) {
            final ORidBag result = new ORidBag();
            boolean updated = false;
            AbstractCollectionConverter.ResultCallback callback = new AbstractCollectionConverter.ResultCallback(){

                @Override
                public void add(Object item) {
                    result.add((OIdentifiable)item);
                }
            };
            for (OIdentifiable identifiable : value) {
                updated = this.convertSingleValue(identifiable, callback, updated);
            }
            if (updated) {
                return result;
            }
            return value;
        }
    }

    private static final class ListConverter
    extends AbstractCollectionConverter<List> {
        public static final ListConverter INSTANCE = new ListConverter();

        private ListConverter() {
        }

        @Override
        public List convert(List value) {
            final ArrayList result = new ArrayList();
            AbstractCollectionConverter.ResultCallback callback = new AbstractCollectionConverter.ResultCallback(){

                @Override
                public void add(Object item) {
                    result.add(item);
                }
            };
            boolean updated = false;
            for (Object item : value) {
                updated = this.convertSingleValue(item, callback, updated);
            }
            if (updated) {
                return result;
            }
            return value;
        }
    }

    private static final class SetConverter
    extends AbstractCollectionConverter<Set> {
        public static final SetConverter INSTANCE = new SetConverter();

        private SetConverter() {
        }

        @Override
        public Set convert(Set value) {
            Set result;
            boolean updated = false;
            if (value instanceof OMVRBTreeRIDSet) {
                OMVRBTreeRIDSet ridSet = new OMVRBTreeRIDSet();
                ridSet.setAutoConvertToRecord(false);
                result = ridSet;
            } else {
                result = new HashSet();
            }
            AbstractCollectionConverter.ResultCallback callback = new AbstractCollectionConverter.ResultCallback(){

                @Override
                public void add(Object item) {
                    result.add(item);
                }
            };
            for (Object item : value) {
                updated = this.convertSingleValue(item, callback, updated);
            }
            if (updated) {
                return result;
            }
            return value;
        }
    }

    private static abstract class AbstractCollectionConverter<T>
    implements ValuesConverter<T> {
        private AbstractCollectionConverter() {
        }

        protected boolean convertSingleValue(Object item, ResultCallback result, boolean updated) {
            if (item == null) {
                return false;
            }
            if (item instanceof OIdentifiable) {
                ValuesConverter converter = ConvertersFactory.INSTANCE.getConverter(item);
                OIdentifiable newValue = converter.convert((OIdentifiable)item);
                result.add(newValue);
                if (!newValue.equals(item)) {
                    updated = true;
                }
            } else {
                ValuesConverter valuesConverter = ConvertersFactory.INSTANCE.getConverter(item.getClass());
                if (valuesConverter == null) {
                    result.add(item);
                } else {
                    Object newValue = valuesConverter.convert(item);
                    if (newValue != item) {
                        updated = true;
                    }
                    result.add(newValue);
                }
            }
            return updated;
        }

        static interface ResultCallback {
            public void add(Object var1);
        }
    }

    private static final class LinksRewriter
    implements ODocumentFieldVisitor {
        private LinksRewriter() {
        }

        @Override
        public Object visitField(OType type, OType linkedType, Object value) {
            ValuesConverter valuesConverter;
            boolean oldAutoConvertValue = false;
            if (value instanceof ORecordLazyMultiValue) {
                ORecordLazyMultiValue multiValue = (ORecordLazyMultiValue)value;
                oldAutoConvertValue = multiValue.isAutoConvertToRecord();
                multiValue.setAutoConvertToRecord(false);
            }
            if ((valuesConverter = ConvertersFactory.INSTANCE.getConverter(value)) == null) {
                return value;
            }
            Object newValue = valuesConverter.convert(value);
            if (value instanceof ORecordLazyMultiValue) {
                ORecordLazyMultiValue multiValue = (ORecordLazyMultiValue)value;
                multiValue.setAutoConvertToRecord(oldAutoConvertValue);
            }
            return newValue;
        }

        @Override
        public boolean goFurther(OType type, OType linkedType, Object value, Object newValue) {
            return true;
        }

        @Override
        public boolean goDeeper(OType type, OType linkedType, Object value) {
            return true;
        }

        @Override
        public boolean updateMode() {
            return true;
        }
    }

    private static final class ConvertersFactory {
        public static final ConvertersFactory INSTANCE = new ConvertersFactory();

        private ConvertersFactory() {
        }

        public ValuesConverter getConverter(Object value) {
            if (value instanceof Map) {
                return MapConverter.INSTANCE;
            }
            if (value instanceof List) {
                return ListConverter.INSTANCE;
            }
            if (value instanceof Set) {
                return SetConverter.INSTANCE;
            }
            if (value instanceof ORidBag) {
                return RidBagConverter.INSTANCE;
            }
            if (value instanceof OIdentifiable) {
                return LinkConverter.INSTANCE;
            }
            return null;
        }
    }

    private static interface ValuesConverter<T> {
        public T convert(T var1);
    }
}

