/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class OTrackedMap<T>
extends LinkedHashMap<Object, T>
implements ORecordElement,
OTrackedMultiValue<Object, T>,
Serializable {
    protected final ORecord sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    private Set<OMultiValueChangeListener<Object, T>> changeListeners = Collections.newSetFromMap(new WeakHashMap());
    protected Class<?> genericClass;
    private final boolean embeddedCollection;

    public OTrackedMap(ORecord iRecord, Map<Object, T> iOrigin, Class<?> cls) {
        this(iRecord);
        this.genericClass = cls;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.putAll(iOrigin);
        }
    }

    public OTrackedMap(ORecord iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        this.embeddedCollection = this.getClass().equals(OTrackedMap.class);
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public T put(Object key, T value) {
        boolean containsKey = this.containsKey(key);
        T oldValue = super.put(key, value);
        if (containsKey && oldValue == value) {
            return oldValue;
        }
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.addOwnerToEmbeddedDoc(value);
        if (containsKey) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, T>(OMultiValueChangeEvent.OChangeType.UPDATE, key, value, oldValue));
        } else {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, T>(OMultiValueChangeEvent.OChangeType.ADD, key, value));
        }
        return oldValue;
    }

    private void addOwnerToEmbeddedDoc(T e) {
        if (this.embeddedCollection && e instanceof ODocument && !((ODocument)e).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)e, this);
        }
    }

    @Override
    public T remove(Object iKey) {
        boolean containsKey = this.containsKey(iKey);
        Object oldValue = super.remove(iKey);
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        if (containsKey) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, iKey, null, oldValue));
        }
        return (T)oldValue;
    }

    @Override
    public void clear() {
        HashMap origValues = this.changeListeners.isEmpty() ? null : new HashMap(this);
        if (origValues == null) {
            for (Object v : this.values()) {
                if (!(v instanceof ODocument)) continue;
                ODocumentInternal.removeOwner((ODocument)v, this);
            }
        }
        super.clear();
        if (origValues != null) {
            for (Map.Entry entry : origValues.entrySet()) {
                if (entry.getValue() instanceof ODocument) {
                    ODocumentInternal.removeOwner((ODocument)entry.getValue(), this);
                }
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent(OMultiValueChangeEvent.OChangeType.REMOVE, entry.getKey(), null, entry.getValue()));
            }
        } else {
            this.setDirty();
        }
    }

    @Override
    public void putAll(Map<?, ? extends T> m) {
        for (Map.Entry<?, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public OTrackedMap<T> setDirty() {
        if (!(this.status == ORecordElement.STATUS.UNMARSHALLING || this.sourceRecord == null || this.sourceRecord.isDirty() && ORecordInternal.isContentChanged(this.sourceRecord))) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<Object, T> changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<Object, T> changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public Map<Object, T> returnOriginalState(List<OMultiValueChangeEvent<Object, T>> multiValueChangeEvents) {
        HashMap<Object, T> reverted = new HashMap<Object, T>(this);
        ListIterator<OMultiValueChangeEvent<Object, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<Object, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
                case UPDATE: {
                    reverted.put(event.getKey(), event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<Object, T> event) {
        if (this.status == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        this.setDirty();
        for (OMultiValueChangeListener<Object, T> changeListener : this.changeListeners) {
            if (changeListener == null) continue;
            changeListener.onAfterRecordChanged(event);
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    public void setGenericClass(Class<?> genericClass) {
        this.genericClass = genericClass;
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }
}

