/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.HashMap;
import java.util.Map;

public class OBasicCommandContext
implements OCommandContext {
    public static final String EXECUTION_BEGUN = "EXECUTION_BEGUN";
    public static final String TIMEOUT_MS = "TIMEOUT_MS";
    public static final String TIMEOUT_STRATEGY = "TIMEOUT_STARTEGY";
    public static final String INVALID_COMPARE_COUNT = "INVALID_COMPARE_COUNT";
    protected boolean recordMetrics = false;
    protected OCommandContext parent;
    protected OCommandContext child;
    protected Map<String, Object> variables;
    private long executionStartedOn;
    private long timeoutMs;
    private OCommandContext.TIMEOUT_STRATEGY timeoutStrategy;

    @Override
    public Object getVariable(String iName) {
        return this.getVariable(iName, null);
    }

    @Override
    public Object getVariable(String iName, Object iDefault) {
        String lastPart;
        String firstPart;
        int pos;
        if (iName == null) {
            return iDefault;
        }
        Object result = null;
        if (iName.startsWith("$")) {
            iName = iName.substring(1);
        }
        if ((pos = OStringSerializerHelper.getLowerIndexOf(iName, 0, ".", "[")) > -1) {
            firstPart = iName.substring(0, pos);
            if (iName.charAt(pos) == '.') {
                ++pos;
            }
            lastPart = iName.substring(pos);
            if (firstPart.equalsIgnoreCase("PARENT") && this.parent != null) {
                result = lastPart.startsWith("$") ? this.parent.getVariable(lastPart.substring(1)) : ODocumentHelper.getFieldValue(this.parent, lastPart);
                return result != null ? result : iDefault;
            }
            if (firstPart.equalsIgnoreCase("ROOT")) {
                OCommandContext p = this;
                while (p.getParent() != null) {
                    p = p.getParent();
                }
                result = lastPart.startsWith("$") ? p.getVariable(lastPart.substring(1)) : ODocumentHelper.getFieldValue(p, lastPart, this);
                return result != null ? result : iDefault;
            }
        } else {
            firstPart = iName;
            lastPart = null;
        }
        if (firstPart.equalsIgnoreCase("CONTEXT")) {
            result = this.getVariables();
        } else if (firstPart.equalsIgnoreCase("PARENT")) {
            result = this.parent;
        } else if (firstPart.equalsIgnoreCase("ROOT")) {
            OCommandContext p = this;
            while (p.getParent() != null) {
                p = p.getParent();
            }
            result = p;
        } else {
            result = this.variables != null && this.variables.containsKey(firstPart) ? this.variables.get(firstPart) : (this.child != null ? this.child.getVariable(firstPart) : this.getVariableFromParentHierarchy(firstPart));
        }
        if (pos > -1) {
            result = ODocumentHelper.getFieldValue(result, lastPart, this);
        }
        return result != null ? result : iDefault;
    }

    protected Object getVariableFromParentHierarchy(String varName) {
        if (this.variables != null && this.variables.containsKey(varName)) {
            return this.variables.get(varName);
        }
        if (this.parent != null && this.parent instanceof OBasicCommandContext) {
            return ((OBasicCommandContext)this.parent).getVariableFromParentHierarchy(varName);
        }
        return null;
    }

    @Override
    public OCommandContext setVariable(String iName, Object iValue) {
        if (iName == null) {
            return null;
        }
        if (iName.startsWith("$")) {
            iName = iName.substring(1);
        }
        this.init();
        int pos = OStringSerializerHelper.getHigherIndexOf(iName, 0, ".", "[");
        if (pos > -1) {
            Object nested = this.getVariable(iName.substring(0, pos));
            if (nested != null && nested instanceof OCommandContext) {
                ((OCommandContext)nested).setVariable(iName.substring(pos + 1), iValue);
            }
        } else {
            this.variables.put(iName, iValue);
        }
        return this;
    }

    @Override
    public OCommandContext incrementVariable(String iName) {
        if (iName != null) {
            if (iName.startsWith("$")) {
                iName = iName.substring(1);
            }
            this.init();
            int pos = OStringSerializerHelper.getHigherIndexOf(iName, 0, ".", "[");
            if (pos > -1) {
                Object nested = this.getVariable(iName.substring(0, pos));
                if (nested != null && nested instanceof OCommandContext) {
                    ((OCommandContext)nested).incrementVariable(iName.substring(pos + 1));
                }
            } else {
                Object v = this.variables.get(iName);
                if (v == null) {
                    this.variables.put(iName, 1);
                } else if (v instanceof Number) {
                    this.variables.put(iName, OType.increment((Number)v, 1));
                } else {
                    throw new IllegalArgumentException("Variable '" + iName + "' is not a number, but: " + v.getClass());
                }
            }
        }
        return this;
    }

    @Override
    public long updateMetric(String iName, long iValue) {
        if (!this.recordMetrics) {
            return -1L;
        }
        this.init();
        Long value = (Long)this.variables.get(iName);
        value = value == null ? Long.valueOf(iValue) : new Long(value + iValue);
        this.variables.put(iName, value);
        return value;
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.child != null) {
            map.putAll(this.child.getVariables());
        }
        if (this.variables != null) {
            map.putAll(this.variables);
        }
        return map;
    }

    @Override
    public OCommandContext setChild(OCommandContext iContext) {
        if (iContext == null) {
            if (this.child != null) {
                this.child.setParent(null);
                this.child = null;
            }
        } else if (this.child != iContext) {
            this.child = iContext;
            iContext.setParent(this);
        }
        return this;
    }

    @Override
    public OCommandContext getParent() {
        return this.parent;
    }

    @Override
    public OCommandContext setParent(OCommandContext iParentContext) {
        if (this.parent != iParentContext) {
            this.parent = iParentContext;
            if (this.parent != null) {
                this.parent.setChild(this);
            }
        }
        return this;
    }

    public String toString() {
        return this.getVariables().toString();
    }

    @Override
    public boolean isRecordingMetrics() {
        return this.recordMetrics;
    }

    @Override
    public OCommandContext setRecordingMetrics(boolean recordMetrics) {
        this.recordMetrics = recordMetrics;
        return this;
    }

    @Override
    public void beginExecution(long iTimeout, OCommandContext.TIMEOUT_STRATEGY iStrategy) {
        if (iTimeout > 0L) {
            this.executionStartedOn = System.currentTimeMillis();
            this.timeoutMs = iTimeout;
            this.timeoutStrategy = iStrategy;
        }
    }

    @Override
    public boolean checkTimeout() {
        if (this.timeoutMs > 0L) {
            if (System.currentTimeMillis() - this.executionStartedOn > this.timeoutMs) {
                switch (this.timeoutStrategy) {
                    case RETURN: {
                        return false;
                    }
                    case EXCEPTION: {
                        throw new OTimeoutException("Command execution timeout exceed (" + this.timeoutMs + "ms)");
                    }
                }
            }
        } else if (this.parent != null) {
            return this.parent.checkTimeout();
        }
        return true;
    }

    private void init() {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
    }
}

