/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OServerAdmin {
    private OStorageRemote storage;
    private int sessionId = -1;
    private byte[] sessionToken = null;

    public OServerAdmin(String iURL) throws IOException {
        if (iURL.startsWith("remote")) {
            iURL = iURL.substring("remote".length() + 1);
        }
        if (!iURL.contains("/")) {
            iURL = iURL + "/";
        }
        this.storage = new OStorageRemote(null, iURL, "", OStorage.STATUS.OPEN);
    }

    public OServerAdmin(OStorageRemote iStorage) {
        this.storage = iStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OServerAdmin connect(String iUserName, String iUserPassword) throws IOException {
        this.storage.setSessionId(null, -1, null);
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)2);
            this.storage.sendClientInfo(network);
            try {
                network.writeString(iUserName);
                network.writeString(iUserPassword);
            }
            finally {
                this.storage.endRequest(network);
            }
            try {
                this.storage.beginResponse(network);
                this.sessionId = network.readInt();
                this.sessionToken = network.readBytes();
                if (this.sessionToken.length == 0) {
                    this.sessionToken = null;
                } else {
                    network.getServiceThread().setTokenBased(true);
                }
                this.storage.setSessionId(network.getServerURL(), this.sessionId, this.sessionToken);
            }
            finally {
                this.storage.endResponse(network);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Cannot connect to the remote server/database '%s'", (Throwable)e, OStorageException.class, this.storage.getURL());
            this.storage.close(true, false);
        }
        return this;
    }

    public synchronized Map<String, String> listDatabases() throws IOException {
        ODocument result = new ODocument();
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)74);
            this.storage.endRequest(network);
            try {
                this.storage.beginResponse(network);
                result.fromStream(network.readBytes());
            }
            finally {
                this.storage.endResponse(network);
            }
        }
        catch (Exception e) {
            this.storage.close(true, false);
            throw new OStorageException("Cannot retrieve the configuration list", e);
        }
        return (Map)result.field("databases");
    }

    public int getSessionId() {
        return this.sessionId;
    }

    @Deprecated
    public synchronized OServerAdmin createDatabase(String iStorageMode) throws IOException {
        return this.createDatabase("document", iStorageMode);
    }

    public synchronized OServerAdmin createDatabase(String iDatabaseType, String iStorageMode) throws IOException {
        return this.createDatabase(this.storage.getName(), iDatabaseType, iStorageMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OServerAdmin createDatabase(String iDatabaseName, String iDatabaseType, String iStorageMode) throws IOException {
        block8: {
            try {
                if (iDatabaseName == null || iDatabaseName.length() <= 0) {
                    OLogManager.instance().error((Object)this, "Cannot create unnamed remote storage. Check your syntax", OStorageException.class);
                    break block8;
                }
                if (iStorageMode == null) {
                    iStorageMode = "csv";
                }
                OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)4);
                try {
                    network.writeString(iDatabaseName);
                    if (network.getSrvProtocolVersion() >= 8) {
                        network.writeString(iDatabaseType);
                    }
                    network.writeString(iStorageMode);
                }
                finally {
                    this.storage.endRequest(network);
                }
                this.storage.getResponse(network);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot create the remote storage: " + this.storage.getName(), (Throwable)e, OStorageException.class, new Object[0]);
                this.storage.close(true, false);
            }
        }
        return this;
    }

    public synchronized boolean existsDatabase() throws IOException {
        return this.existsDatabase(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean existsDatabase(String storageType) throws IOException {
        OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)6);
        try {
            network.writeString(this.storage.getName());
            network.writeString(storageType);
        }
        finally {
            this.storage.endRequest(network);
        }
        try {
            this.storage.beginResponse(network);
            boolean bl = network.readByte() == 1;
            this.storage.endResponse(network);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.storage.endResponse(network);
                throw throwable;
            }
            catch (Exception e) {
                this.storage.close(true, false);
                throw new OStorageException("Error on checking existence of the remote storage: " + this.storage.getName(), e);
            }
        }
    }

    @Deprecated
    public OServerAdmin deleteDatabase(String storageType) throws IOException {
        return this.dropDatabase(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OServerAdmin dropDatabase(String storageType) throws IOException {
        boolean retry = true;
        while (retry) {
            try {
                OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)7);
                try {
                    network.writeString(this.storage.getName());
                    network.writeString(storageType);
                }
                finally {
                    this.storage.endRequest(network);
                }
                this.storage.getResponse(network);
                retry = false;
            }
            catch (OModificationOperationProhibitedException oope) {
                retry = this.handleDBFreeze();
            }
            catch (Exception e) {
                throw new OStorageException("Cannot delete the remote storage: " + this.storage.getName(), e);
            }
        }
        for (OStorage s : Orient.instance().getStorages()) {
            if (!s.getURL().startsWith(this.getURL())) continue;
            s.removeResource(OSchema.class.getSimpleName());
            s.removeResource(OIndexManager.class.getSimpleName());
            s.removeResource(OSecurity.class.getSimpleName());
        }
        ODatabaseRecordThreadLocal.INSTANCE.remove();
        return this;
    }

    public synchronized OServerAdmin freezeDatabase(String storageType) throws IOException {
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)94);
            try {
                network.writeString(this.storage.getName());
                network.writeString(storageType);
            }
            finally {
                this.storage.endRequest(network);
            }
            this.storage.getResponse(network);
        }
        catch (Exception e) {
            throw new OStorageException("Cannot freeze the remote storage: " + this.storage.getName(), e);
        }
        return this;
    }

    public synchronized OServerAdmin releaseDatabase(String storageType) throws IOException {
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)95);
            try {
                network.writeString(this.storage.getName());
                network.writeString(storageType);
            }
            finally {
                this.storage.endRequest(network);
            }
            this.storage.getResponse(network);
        }
        catch (Exception e) {
            throw new OStorageException("Cannot release the remote storage: " + this.storage.getName(), e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OServerAdmin freezeCluster(int clusterId, String storageType) throws IOException {
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)96);
            try {
                network.writeString(this.storage.getName());
                network.writeShort((short)clusterId);
                network.writeString(storageType);
            }
            finally {
                this.storage.endRequest(network);
            }
            this.storage.getResponse(network);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OStorageException("Cannot freeze the remote cluster " + clusterId + " on storage: " + this.storage.getName(), e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OServerAdmin releaseCluster(int clusterId, String storageType) throws IOException {
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)97);
            try {
                network.writeString(this.storage.getName());
                network.writeShort((short)clusterId);
                network.writeString(storageType);
            }
            finally {
                this.storage.endRequest(network);
            }
            this.storage.getResponse(network);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OStorageException("Cannot release the remote cluster " + clusterId + " on storage: " + this.storage.getName(), e);
        }
        return this;
    }

    public ODocument clusterStatus() {
        ODocument response = this.sendRequest((byte)92, new ODocument().field("operation", "status"), "Cluster status");
        OLogManager.instance().debug((Object)this, "Cluster status %s", response.toJSON("prettyPrint"));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OServerAdmin copyDatabase(String databaseName, String iDatabaseUserName, String iDatabaseUserPassword, String iRemoteName, String iRemoteEngine) throws IOException {
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)90);
            try {
                network.writeString(databaseName);
                network.writeString(iDatabaseUserName);
                network.writeString(iDatabaseUserPassword);
                network.writeString(iRemoteName);
                network.writeString(iRemoteEngine);
            }
            finally {
                this.storage.endRequest(network);
            }
            this.storage.getResponse(network);
            OLogManager.instance().debug((Object)this, "Database '%s' has been copied to the server '%s'", databaseName, iRemoteName);
        }
        catch (Exception e) {
            throw new OStorageException("Cannot copy the database: " + databaseName, e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, String> getGlobalConfigurations() throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)72);
            this.storage.endRequest(network);
            try {
                this.storage.beginResponse(network);
                int num = network.readShort();
                for (int i = 0; i < num; ++i) {
                    config.put(network.readString(), network.readString());
                }
            }
            finally {
                this.storage.endResponse(network);
            }
        }
        catch (Exception e) {
            this.storage.close(true, false);
            throw new OStorageException("Cannot retrieve the configuration list", e);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getGlobalConfiguration(OGlobalConfiguration config) throws IOException {
        OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)70);
        network.writeString(config.getKey());
        network.endRequest();
        try {
            this.storage.beginResponse(network);
            String string = network.readString();
            this.storage.endResponse(network);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.storage.endResponse(network);
                throw throwable;
            }
            catch (Exception e) {
                this.storage.close(true, false);
                throw new OStorageException("Cannot retrieve the configuration value: " + config.getKey(), e);
            }
        }
    }

    public synchronized OServerAdmin setGlobalConfiguration(OGlobalConfiguration config, Object iValue) throws IOException {
        try {
            OChannelBinaryAsynchClient network = this.storage.beginRequest((byte)71);
            network.writeString(config.getKey());
            network.writeString(iValue != null ? iValue.toString() : "");
            this.storage.endRequest(network);
            this.storage.getResponse(network);
        }
        catch (Exception e) {
            this.storage.close(true, false);
            throw new OStorageException("Cannot set the configuration value: " + config.getKey(), e);
        }
        return this;
    }

    public synchronized void close() {
        this.storage.close();
    }

    public synchronized void close(boolean iForce) {
        this.storage.close(iForce, false);
    }

    public synchronized String getURL() {
        return this.storage != null ? this.storage.getURL() : null;
    }

    public boolean isConnected() {
        return this.storage != null && !this.storage.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODocument sendRequest(byte iRequest, ODocument iPayLoad, String iActivity) {
        boolean retry = true;
        while (retry) {
            OChannelBinaryAsynchClient network = null;
            network = this.storage.beginRequest(iRequest);
            try {
                network.writeBytes(iPayLoad.toStream());
            }
            finally {
                this.storage.endRequest(network);
            }
            retry = false;
            try {
                this.storage.beginResponse(network);
                ODocument oDocument = new ODocument(network.readBytes());
                this.storage.endResponse(network);
                return oDocument;
            }
            catch (Throwable throwable) {
                try {
                    this.storage.endResponse(network);
                    throw throwable;
                }
                catch (OModificationOperationProhibitedException ompe) {
                    retry = this.handleDBFreeze();
                }
                catch (IOException e) {
                    if (network != null) {
                        this.storage.getEngine().getConnectionManager().remove(network);
                    }
                    throw new OStorageException("Error on executing  '" + iActivity + "'", e);
                }
                catch (Exception e2) {
                    if (network != null) {
                        this.storage.getEngine().getConnectionManager().release(network);
                    }
                    throw new OStorageException("Error on executing  '" + iActivity + "'", e2);
                }
            }
        }
        return null;
    }

    private boolean handleDBFreeze() {
        OLogManager.instance().warn((Object)this, "DB is frozen will wait for " + OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValue() + " ms. and then retry.", new Object[0]);
        boolean retry = true;
        try {
            Thread.sleep(OGlobalConfiguration.CLIENT_DB_RELEASE_WAIT_TIMEOUT.getValueAsInteger());
        }
        catch (InterruptedException ie) {
            retry = false;
            Thread.currentThread().interrupt();
        }
        return retry;
    }
}

