/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types.legacy;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OCharSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.nio.ByteOrder;

public class OStringSerializer_1_5_1
implements OBinarySerializer<String> {
    public static final OStringSerializer_1_5_1 INSTANCE = new OStringSerializer_1_5_1();
    public static final byte ID = 13;
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();

    @Override
    public int getObjectSize(String object, Object ... hints) {
        return object.length() * 2 + 4;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition, Object ... hints) {
        OCharSerializer charSerializer = OCharSerializer.INSTANCE;
        int length = object.length();
        OIntegerSerializer.INSTANCE.serializeLiteral(length, stream, startPosition);
        for (int i = 0; i < length; ++i) {
            charSerializer.serializeLiteral(object.charAt(i), stream, startPosition + 4 + i * 2);
        }
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        OCharSerializer charSerializer = OCharSerializer.INSTANCE;
        int len = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
        StringBuilder stringBuilder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(charSerializer.deserializeLiteral(stream, startPosition + 4 + i * 2));
        }
        return stringBuilder.toString();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition) * 2 + 4;
    }

    @Override
    public byte getId() {
        return 13;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition) * 2 + 4;
    }

    @Override
    public void serializeNativeObject(String object, byte[] stream, int startPosition, Object ... hints) {
        int length = object.length();
        OIntegerSerializer.INSTANCE.serializeNative(length, stream, startPosition, new Object[0]);
        int pos = startPosition + 4;
        for (int i = 0; i < length; ++i) {
            char strChar = object.charAt(i);
            CONVERTER.putChar(stream, pos, strChar, ByteOrder.nativeOrder());
            pos += 2;
        }
    }

    @Override
    public String deserializeNativeObject(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
        char[] buffer = new char[len];
        int pos = startPosition + 4;
        for (int i = 0; i < len; ++i) {
            buffer[i] = CONVERTER.getChar(stream, pos, ByteOrder.nativeOrder());
            pos += 2;
        }
        return new String(buffer);
    }

    @Override
    public void serializeInDirectMemoryObject(String object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        int length = object.length();
        pointer.setInt(offset, length);
        offset += 4L;
        for (int i = 0; i < length; ++i) {
            char strChar = object.charAt(i);
            pointer.setChar(offset, strChar);
            offset += 2L;
        }
    }

    @Override
    public String deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        int len = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(pointer, offset);
        char[] buffer = new char[len];
        offset += 4L;
        for (int i = 0; i < len; ++i) {
            buffer[i] = pointer.getChar(offset);
            offset += 2L;
        }
        return new String(buffer);
    }

    @Override
    public String deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        int len = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(wrapper, offset);
        char[] buffer = new char[len];
        offset += 4L;
        for (int i = 0; i < len; ++i) {
            buffer[i] = wrapper.getChar(offset);
            offset += 2L;
        }
        return new String(buffer);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getInt(offset) * 2 + 4;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getInt(offset) * 2 + 4;
    }

    @Override
    public String preprocess(String value, Object ... hints) {
        return value;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }
}

