/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.nio.ByteOrder;

public class OShortSerializer
implements OBinarySerializer<Short> {
    public static final byte ID = 12;
    public static final int SHORT_SIZE = 2;
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static OShortSerializer INSTANCE = new OShortSerializer();

    @Override
    public int getObjectSize(Short object, Object ... hints) {
        return 2;
    }

    @Override
    public void serialize(Short object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object, stream, startPosition);
    }

    public void serializeLiteral(short value, byte[] stream, int startPosition) {
        stream[startPosition] = (byte)(value >>> 8 & 0xFF);
        stream[startPosition + 1] = (byte)(value >>> 0 & 0xFF);
    }

    @Override
    public Short deserialize(byte[] stream, int startPosition) {
        return this.deserializeLiteral(stream, startPosition);
    }

    public short deserializeLiteral(byte[] stream, int startPosition) {
        return (short)(stream[startPosition] << 8 | stream[startPosition + 1] & 0xFF);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public void serializeNativeObject(Short object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putShort(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    @Override
    public Short deserializeNativeObject(byte[] stream, int startPosition) {
        return CONVERTER.getShort(stream, startPosition, ByteOrder.nativeOrder());
    }

    @Override
    public void serializeInDirectMemoryObject(Short object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setShort(offset, object);
    }

    @Override
    public Short deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        return pointer.getShort(offset);
    }

    @Override
    public Short deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getShort(offset);
    }

    public void serializeNative(short object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putShort(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    public short deserializeNative(byte[] stream, int startPosition) {
        return CONVERTER.getShort(stream, startPosition, ByteOrder.nativeOrder());
    }

    public void serializeInDirectMemory(short object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setShort(offset, object);
    }

    public short deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getShort(offset);
    }

    public short deserializeFromDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getShort(offset);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 2;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return 2;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 2;
    }

    @Override
    public Short preprocess(Short value, Object ... hints) {
        return value;
    }
}

