/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;

public class OByteSerializer
implements OBinarySerializer<Byte> {
    public static final int BYTE_SIZE = 1;
    public static final byte ID = 2;
    public static OByteSerializer INSTANCE = new OByteSerializer();

    @Override
    public int getObjectSize(Byte object, Object ... hints) {
        return 1;
    }

    @Override
    public void serialize(Byte object, byte[] stream, int startPosition, Object ... hints) {
        stream[startPosition] = object;
    }

    public void serializeLiteral(byte value, byte[] stream, int startPosition) {
        stream[startPosition] = value;
    }

    @Override
    public Byte deserialize(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    public byte deserializeLiteral(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return this.getObjectSize(stream, startPosition);
    }

    @Override
    public void serializeNativeObject(Byte object, byte[] stream, int startPosition, Object ... hints) {
        this.serialize(object, stream, startPosition, new Object[0]);
    }

    public void serializeNative(byte object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object, stream, startPosition);
    }

    @Override
    public Byte deserializeNativeObject(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    public byte deserializeNative(byte[] stream, int startPosition) {
        return stream[startPosition];
    }

    @Override
    public void serializeInDirectMemoryObject(Byte object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setByte(offset, object);
    }

    public void serializeInDirectMemory(byte object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setByte(offset, object);
    }

    @Override
    public Byte deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        return pointer.getByte(offset);
    }

    @Override
    public Byte deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getByte(offset);
    }

    public byte deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getByte(offset);
    }

    public byte deserializeFromDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getByte(offset);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 1;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return 1;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 1;
    }

    @Override
    public Byte preprocess(Byte value, Object ... hints) {
        return value;
    }
}

