/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.nio.ByteOrder;
import java.util.Arrays;

public class OBinaryTypeSerializer
implements OBinarySerializer<byte[]> {
    public static final OBinaryTypeSerializer INSTANCE = new OBinaryTypeSerializer();
    public static final byte ID = 17;
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();

    public int getObjectSize(int length) {
        return length + 4;
    }

    @Override
    public int getObjectSize(byte[] object, Object ... hints) {
        return object.length + 4;
    }

    @Override
    public void serialize(byte[] object, byte[] stream, int startPosition, Object ... hints) {
        int len = object.length;
        OIntegerSerializer.INSTANCE.serializeLiteral(len, stream, startPosition);
        System.arraycopy(object, 0, stream, startPosition + 4, len);
    }

    @Override
    public byte[] deserialize(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
        return Arrays.copyOfRange(stream, startPosition + 4, startPosition + 4 + len);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition) + 4;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder()) + 4;
    }

    @Override
    public void serializeNativeObject(byte[] object, byte[] stream, int startPosition, Object ... hints) {
        int len = object.length;
        CONVERTER.putInt(stream, startPosition, len, ByteOrder.nativeOrder());
        System.arraycopy(object, 0, stream, startPosition + 4, len);
    }

    @Override
    public byte[] deserializeNativeObject(byte[] stream, int startPosition) {
        int len = CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder());
        return Arrays.copyOfRange(stream, startPosition + 4, startPosition + 4 + len);
    }

    @Override
    public void serializeInDirectMemoryObject(byte[] object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        int len = object.length;
        pointer.setInt(offset, len);
        pointer.set(offset += 4L, object, 0, len);
    }

    @Override
    public byte[] deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        int len = pointer.getInt(offset);
        return pointer.get(offset += 4L, len);
    }

    @Override
    public byte[] deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        short len = wrapper.getShort(offset);
        return wrapper.get(offset += 4L, len);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getInt(offset) + 4;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return wrapper.getInt(offset) + 4;
    }

    @Override
    public byte getId() {
        return 17;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public byte[] preprocess(byte[] value, Object ... hints) {
        return value;
    }
}

