/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.directmemory.ODirectMemoryMXBean;
import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.directmemory.OTrackedDirectMemoryPointer;
import com.orientechnologies.common.directmemory.OUntrackedDirectMemoryPointer;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class ODirectMemoryPointerFactory
extends NotificationBroadcasterSupport
implements ODirectMemoryMXBean,
OOrientStartupListener,
OOrientShutdownListener {
    public static final String MBEAN_NAME = "com.orientechnologies.common.directmemory:type=ODirectMemoryMXBean";
    private static final ODirectMemoryPointerFactory INSTANCE = new ODirectMemoryPointerFactory();
    private final boolean isTracked = OGlobalConfiguration.DIRECT_MEMORY_TRACK_MODE.getValueAsBoolean();
    private final boolean safeMode = OGlobalConfiguration.DIRECT_MEMORY_SAFE_MODE.getValueAsBoolean();
    private final ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();
    private final ODistributedCounter memorySize = new ODistributedCounter();
    private final AtomicLong sequenceNumber = new AtomicLong();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();

    public static ODirectMemoryPointerFactory instance() {
        return INSTANCE;
    }

    public ODirectMemoryPointerFactory() {
        Orient.instance().registerWeakOrientShutdownListener(this);
        Orient.instance().registerWeakOrientStartupListener(this);
        try {
            this.registerMBean();
        }
        catch (RuntimeException e) {
            OLogManager.instance().error((Object)this, "Error during registration of direct memory MBean", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void onShutdown() {
        try {
            this.unregisterMBean();
        }
        catch (RuntimeException e) {
            OLogManager.instance().error((Object)this, "Error during unregistration of direct memory MBean", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void onStartup() {
        try {
            this.registerMBean();
        }
        catch (RuntimeException e) {
            OLogManager.instance().error((Object)this, "Error during registration of direct memory MBean", (Throwable)e, new Object[0]);
        }
    }

    public void registerMBean() {
        if (this.isTracked && this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                server.registerMBean(this, mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException("Error during registration of direct memory MBean", e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new IllegalStateException("Error during registration of direct memory MBean", e);
            }
            catch (MBeanRegistrationException e) {
                throw new IllegalStateException("Error during registration of direct memory MBean", e);
            }
            catch (NotCompliantMBeanException e) {
                throw new IllegalStateException("Error during registration of direct memory MBean", e);
            }
        }
    }

    public void unregisterMBean() {
        if (this.isTracked && this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException("Error during unregistration of direct memory MBean", e);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException("Error during unregistration of direct memory MBean", e);
            }
            catch (MBeanRegistrationException e) {
                throw new IllegalStateException("Error during unregistration of direct memory MBean", e);
            }
        }
    }

    public ODirectMemoryPointer createPointer(byte[] data) {
        if (this.isTracked) {
            OTrackedDirectMemoryPointer pointer = new OTrackedDirectMemoryPointer(data, this, this.safeMode, this.directMemory);
            this.memorySize.add(data.length);
            return pointer;
        }
        return new OUntrackedDirectMemoryPointer(data, this.safeMode, this.directMemory, this);
    }

    public ODirectMemoryPointer createPointer(long pageSize) {
        if (this.isTracked) {
            OTrackedDirectMemoryPointer pointer = new OTrackedDirectMemoryPointer(pageSize, this, this.safeMode, this.directMemory);
            this.memorySize.add(pageSize);
            return pointer;
        }
        return new OUntrackedDirectMemoryPointer(this.safeMode, this.directMemory, pageSize, this);
    }

    public void memoryLeakDetected(StackTraceElement[] allocationStackTrace) {
        Notification notification = new Notification("com.orientechnologies.common.directmemory.memoryleak", (Object)MBEAN_NAME, this.sequenceNumber.getAndIncrement(), System.currentTimeMillis());
        notification.setUserData(allocationStackTrace);
        this.sendNotification(notification);
    }

    public void memoryFreed(long pageSize) {
        this.memorySize.add(-pageSize);
    }

    @Override
    public long getSize() {
        return this.memorySize.get();
    }

    @Override
    public long getSizeInKB() {
        return this.getSize() / 1024L;
    }

    @Override
    public long getSizeInMB() {
        return this.getSizeInKB() / 1024L;
    }

    @Override
    public long getSizeInGB() {
        return this.getSizeInMB() / 1024L;
    }
}

