/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.OUnsafeMemory;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.nio.OJNADirectMemory;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.sun.jna.Platform;

class ODirectMemoryFactory {
    public static final ODirectMemoryFactory INSTANCE = new ODirectMemoryFactory();
    private static final ODirectMemory directMemory;

    ODirectMemoryFactory() {
    }

    public ODirectMemory directMemory() {
        return directMemory;
    }

    static {
        ODirectMemory localDirectMemory = null;
        try {
            Class<?> sunClass;
            boolean needToUseUnsafe = false;
            if (Platform.isAIX()) {
                OLogManager.instance().warn(ODirectMemoryFactory.class, "System is running on AIX OS, automatically switch to usage of Unsafe class", new Object[0]);
                needToUseUnsafe = true;
            }
            if ((needToUseUnsafe |= OGlobalConfiguration.MEMORY_USE_UNSAFE.getValueAsBoolean()) && (sunClass = Class.forName("sun.misc.Unsafe")) != null) {
                localDirectMemory = OUnsafeMemory.INSTANCE;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (localDirectMemory == null) {
            localDirectMemory = new OJNADirectMemory();
        }
        directMemory = localDirectMemory;
    }
}

