/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.concur.lock.OLockException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OSharedResourceAdaptive {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicInteger users = new AtomicInteger(0);
    private final boolean concurrent;
    private final int timeout;
    private final boolean ignoreThreadInterruption;
    private int scaledUpCount = 0;

    protected OSharedResourceAdaptive() {
        this.concurrent = true;
        this.timeout = 0;
        this.ignoreThreadInterruption = false;
    }

    protected OSharedResourceAdaptive(int iTimeout) {
        this.concurrent = true;
        this.timeout = iTimeout;
        this.ignoreThreadInterruption = false;
    }

    protected OSharedResourceAdaptive(boolean iConcurrent) {
        this.concurrent = iConcurrent;
        this.timeout = 0;
        this.ignoreThreadInterruption = false;
    }

    protected OSharedResourceAdaptive(boolean iConcurrent, int iTimeout, boolean ignoreThreadInterruption) {
        this.concurrent = iConcurrent;
        this.timeout = iTimeout;
        this.ignoreThreadInterruption = ignoreThreadInterruption;
    }

    public int getUsers() {
        return this.users.get();
    }

    public int addUser() {
        return this.users.incrementAndGet();
    }

    public int removeUser() {
        if (this.users.get() < 1) {
            throw new IllegalStateException("Cannot remove user of the shared resource " + this.toString() + " because no user is using it");
        }
        return this.users.decrementAndGet();
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public boolean assertExclusiveLockHold() {
        return this.lock.getWriteHoldCount() > 0;
    }

    public boolean assertSharedLockHold() {
        return this.lock.getReadHoldCount() > 0;
    }

    protected void acquireExclusiveLock() {
        if (this.concurrent) {
            if (this.timeout > 0) {
                try {
                    if (this.lock.writeLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    if (this.ignoreThreadInterruption) {
                        try {
                            if (this.lock.writeLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    throw new OLockException("Thread interrupted while waiting for resource of class '" + this.getClass() + "' with timeout=" + this.timeout, e);
                }
                this.throwTimeoutException(this.lock.writeLock());
            } else {
                this.lock.writeLock().lock();
            }
        }
    }

    protected boolean tryAcquireExclusiveLock() {
        return !this.concurrent || this.lock.writeLock().tryLock();
    }

    protected void acquireSharedLock() {
        if (this.concurrent) {
            if (this.timeout > 0) {
                try {
                    if (this.lock.readLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    if (this.ignoreThreadInterruption) {
                        try {
                            if (this.lock.readLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    throw new OLockException("Thread interrupted while waiting for resource of class '" + this.getClass() + "' with timeout=" + this.timeout, e);
                }
                this.throwTimeoutException(this.lock.readLock());
            } else {
                this.lock.readLock().lock();
            }
        }
    }

    protected boolean tryAcquireSharedLock() {
        return !this.concurrent || this.lock.readLock().tryLock();
    }

    protected void releaseExclusiveLock() {
        if (this.concurrent) {
            this.lock.writeLock().unlock();
        }
    }

    protected void releaseSharedLock() {
        if (this.concurrent) {
            this.lock.readLock().unlock();
        }
    }

    private void throwTimeoutException(Lock lock) {
        String owner = this.extractLockOwnerStackTrace(lock);
        throw new OTimeoutException("Timeout on acquiring exclusive lock against resource of class: " + this.getClass() + " with timeout=" + this.timeout + (owner != null ? "\n" + owner : ""));
    }

    private String extractLockOwnerStackTrace(Lock lock) {
        try {
            StackTraceElement[] stackTrace;
            Field syncField = lock.getClass().getDeclaredField("sync");
            syncField.setAccessible(true);
            Object sync = syncField.get(lock);
            Method getOwner = sync.getClass().getSuperclass().getDeclaredMethod("getOwner", new Class[0]);
            getOwner.setAccessible(true);
            Thread owner = (Thread)getOwner.invoke(sync, new Object[0]);
            if (owner == null) {
                return null;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.append("Owner thread : ").append(owner.toString()).append("\n");
            for (StackTraceElement traceElement : stackTrace = owner.getStackTrace()) {
                printWriter.println("\tat " + traceElement);
            }
            printWriter.flush();
            return stringWriter.toString();
        }
        catch (RuntimeException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }
}

