/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.hash.OMurmurHash3;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public final class OThreadCountersHashTable
implements OOrientStartupListener,
OOrientShutdownListener {
    private static final int SEED = 362498820;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_SIZE = 1 << 32 - Integer.numberOfLeadingZeros((NCPU << 2) - 1);
    public static final int THRESHOLD = 10;
    private final boolean deadThreadsAreAllowed;
    private volatile ThreadLocal<HashEntry> hashEntry = new ThreadLocal();
    private volatile int activeTableIndex = 0;
    private final AtomicReference<AtomicReference<EntryHolder>[]>[] tables;
    private final AtomicInteger[] busyCounters;
    private final AtomicBoolean tablesAreBusy = new AtomicBoolean(false);

    public OThreadCountersHashTable() {
        this(DEFAULT_SIZE, false);
    }

    public OThreadCountersHashTable(int initialSize, boolean deadThreadsAreAllowed) {
        int i;
        this.deadThreadsAreAllowed = deadThreadsAreAllowed;
        AtomicReference[] activeTable = new AtomicReference[initialSize << 1];
        AtomicReference[] tables = new AtomicReference[32];
        for (i = 0; i < activeTable.length; ++i) {
            activeTable[i] = new AtomicReference<EntryHolder>(new EntryHolder(0L, null, false));
        }
        tables[0] = new AtomicReference<AtomicReference[]>(activeTable);
        for (i = 1; i < tables.length; ++i) {
            tables[i] = new AtomicReference<Object>(null);
        }
        AtomicInteger[] counters = new AtomicInteger[32];
        for (int i2 = 0; i2 < counters.length; ++i2) {
            counters[i2] = new AtomicInteger();
        }
        this.busyCounters = counters;
        this.tables = tables;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    public void increment() {
        HashEntry entry = this.hashEntry.get();
        if (entry == null) {
            Thread thread = Thread.currentThread();
            entry = new HashEntry(thread, OThreadCountersHashTable.hashCodesByThreadId(thread.getId()));
            assert (this.search(entry.thread) == null);
            this.insert(entry);
            assert (this.search(entry.thread).thread == thread);
            this.hashEntry.set(entry);
        }
        entry.threadCounter++;
    }

    public void decrement() {
        HashEntry entry = this.hashEntry.get();
        assert (entry != null);
        entry.threadCounter--;
    }

    public boolean isEmpty() {
        int activeTableIndex;
        do {
            activeTableIndex = this.activeTableIndex;
            for (int i = 0; i <= activeTableIndex; ++i) {
                AtomicReference<EntryHolder>[] table;
                if (i != activeTableIndex) {
                    while (this.busyCounters[i].get() != 0) {
                    }
                }
                if (!this.tableCountersNotEmpty(table = this.tables[i].get())) continue;
                return false;
            }
        } while (this.activeTableIndex != activeTableIndex);
        return true;
    }

    private boolean tableCountersNotEmpty(AtomicReference<EntryHolder>[] table) {
        for (AtomicReference<EntryHolder> entryHolderRef : table) {
            EntryHolder entryHolder = entryHolderRef.get();
            if (this.entryIsEmpty(entryHolder) || entryHolder.entry.threadCounter <= 0L) continue;
            return true;
        }
        return false;
    }

    private boolean entryIsEmpty(EntryHolder entryHolder) {
        if (this.deadThreadsAreAllowed) {
            return entryHolder.entry == null;
        }
        return entryHolder.entry == null || !entryHolder.entry.thread.isAlive();
    }

    HashEntry search(Thread thread) {
        int activeTableIndex;
        int[] hashCodes = OThreadCountersHashTable.hashCodesByThreadId(thread.getId());
        do {
            activeTableIndex = this.activeTableIndex;
            for (int i = 0; i <= activeTableIndex; ++i) {
                HashEntry entry;
                AtomicReference<EntryHolder>[] table = this.tables[i].get();
                if (i != activeTableIndex) {
                    while (this.busyCounters[i].get() != 0) {
                    }
                }
                if ((entry = OThreadCountersHashTable.searchInTables(thread, hashCodes, table)) == null) continue;
                return entry;
            }
        } while (activeTableIndex != this.activeTableIndex);
        return null;
    }

    private static HashEntry searchInTables(Thread thread, int[] hashCodes, AtomicReference<EntryHolder>[] tables) {
        EntryHolder secondEntryHolderRnd2;
        EntryHolder firstEntryHolderRnd2;
        EntryHolder secondEntryHolderRnd1;
        EntryHolder firstEntryHolderRnd1;
        do {
            int firstTableIndex;
            if ((firstEntryHolderRnd1 = tables[firstTableIndex = OThreadCountersHashTable.firstSubTableIndex(hashCodes, tables.length)].get()).entry != null && firstEntryHolderRnd1.entry.thread == thread) {
                return firstEntryHolderRnd1.entry;
            }
            int secondTableIndex = OThreadCountersHashTable.secondSubTableIndex(hashCodes, tables.length);
            secondEntryHolderRnd1 = tables[secondTableIndex].get();
            if (secondEntryHolderRnd1.entry != null && secondEntryHolderRnd1.entry.thread == thread) {
                return secondEntryHolderRnd1.entry;
            }
            firstEntryHolderRnd2 = tables[firstTableIndex].get();
            if (firstEntryHolderRnd2.entry != null && firstEntryHolderRnd2.entry.thread == thread) {
                return firstEntryHolderRnd2.entry;
            }
            secondEntryHolderRnd2 = tables[secondTableIndex].get();
            if (secondEntryHolderRnd2.entry == null || secondEntryHolderRnd2.entry.thread != thread) continue;
            return secondEntryHolderRnd2.entry;
        } while (OThreadCountersHashTable.checkCounter(firstEntryHolderRnd1.counter, secondEntryHolderRnd1.counter, firstEntryHolderRnd2.counter, secondEntryHolderRnd2.counter));
        return null;
    }

    private FindResult find(Thread thread, int[] hashCodes, AtomicReference<EntryHolder>[] tables) {
        EntryHolder secondEntryHolderRnd2;
        EntryHolder firstEntryHolderRnd2;
        while (true) {
            FindResult result = null;
            int firstTableIndex = OThreadCountersHashTable.firstSubTableIndex(hashCodes, tables.length);
            EntryHolder firstEntryHolderRnd1 = tables[firstTableIndex].get();
            int secondTableIndex = OThreadCountersHashTable.secondSubTableIndex(hashCodes, tables.length);
            EntryHolder secondEntryHolderRnd1 = tables[secondTableIndex].get();
            if (firstEntryHolderRnd1.markedForRelocation) {
                this.helpRelocate(firstTableIndex, false, tables);
                continue;
            }
            if (firstEntryHolderRnd1.entry != null && firstEntryHolderRnd1.entry.thread == thread) {
                result = new FindResult(true, true, firstEntryHolderRnd1, secondEntryHolderRnd1);
            }
            if (secondEntryHolderRnd1.markedForRelocation) {
                this.helpRelocate(secondTableIndex, false, tables);
                continue;
            }
            if (secondEntryHolderRnd1.entry != null && secondEntryHolderRnd1.entry.thread == thread) {
                assert (result == null);
                result = new FindResult(true, false, firstEntryHolderRnd1, secondEntryHolderRnd1);
            }
            if (result != null) {
                return result;
            }
            firstEntryHolderRnd2 = tables[firstTableIndex].get();
            secondEntryHolderRnd2 = tables[secondTableIndex].get();
            if (firstEntryHolderRnd2.markedForRelocation) {
                this.helpRelocate(firstTableIndex, false, tables);
                continue;
            }
            if (firstEntryHolderRnd2.entry != null && firstEntryHolderRnd2.entry.thread == thread) {
                result = new FindResult(true, true, firstEntryHolderRnd2, secondEntryHolderRnd2);
            }
            if (secondEntryHolderRnd2.markedForRelocation) {
                this.helpRelocate(secondTableIndex, false, tables);
                continue;
            }
            if (secondEntryHolderRnd2.entry != null && secondEntryHolderRnd2.entry.thread == thread) {
                assert (result == null);
                result = new FindResult(true, false, firstEntryHolderRnd1, secondEntryHolderRnd1);
            }
            if (result != null) {
                return result;
            }
            if (!OThreadCountersHashTable.checkCounter(firstEntryHolderRnd1.counter, secondEntryHolderRnd1.counter, firstEntryHolderRnd2.counter, secondEntryHolderRnd2.counter)) break;
        }
        return new FindResult(false, false, firstEntryHolderRnd2, secondEntryHolderRnd2);
    }

    private static boolean checkCounter(long firstEntryRnd1, long secondEntryRnd1, long firstEntryRnd2, long secondEntryRnd2) {
        return firstEntryRnd2 - firstEntryRnd1 >= 2L && secondEntryRnd2 - secondEntryRnd1 >= 2L && secondEntryRnd2 - firstEntryRnd1 >= 3L;
    }

    void insert(Thread thread) {
        HashEntry entry = new HashEntry(thread, OThreadCountersHashTable.hashCodesByThreadId(thread.getId()));
        this.insert(entry);
    }

    private void insert(HashEntry newEntry) {
        while (true) {
            int activeTableIndex = this.activeTableIndex;
            AtomicReference<EntryHolder>[] table = this.tables[activeTableIndex].get();
            AtomicInteger counter = this.busyCounters[activeTableIndex];
            counter.getAndIncrement();
            boolean result = this.insertInTables(newEntry, table);
            counter.getAndDecrement();
            if (result) break;
            if (this.rehash()) continue;
            LockSupport.parkNanos(10L);
        }
    }

    private boolean insertInTables(HashEntry newEntry, AtomicReference<EntryHolder>[] tables) {
        do {
            int secondTableIndex;
            EntryHolder holder;
            int firstTableIndex;
            FindResult result = this.find(newEntry.thread, newEntry.hashCodes, tables);
            assert (!result.found);
            if (this.entryIsEmpty(result.firstEntryHolder) && tables[firstTableIndex = OThreadCountersHashTable.firstSubTableIndex(newEntry.hashCodes, tables.length)].compareAndSet(holder = result.firstEntryHolder, new EntryHolder(holder.counter, newEntry, false))) {
                return true;
            }
            if (!this.entryIsEmpty(result.secondEntryHolder) || !tables[secondTableIndex = OThreadCountersHashTable.secondSubTableIndex(newEntry.hashCodes, tables.length)].compareAndSet(holder = result.secondEntryHolder, new EntryHolder(holder.counter, newEntry, false))) continue;
            return true;
        } while (this.relocate(OThreadCountersHashTable.firstSubTableIndex(newEntry.hashCodes, tables.length), tables));
        return false;
    }

    private boolean rehash() {
        if (!this.tablesAreBusy.compareAndSet(false, true)) {
            return false;
        }
        AtomicReference<EntryHolder>[] activeTable = this.tables[this.activeTableIndex].get();
        AtomicReference[] newActiveTable = new AtomicReference[activeTable.length << 1];
        for (int i = 0; i < newActiveTable.length; ++i) {
            newActiveTable[i] = new AtomicReference<EntryHolder>(new EntryHolder(0L, null, false));
        }
        this.tables[this.activeTableIndex + 1].set(newActiveTable);
        ++this.activeTableIndex;
        this.tablesAreBusy.set(false);
        return true;
    }

    private boolean relocate(int entryIndex, AtomicReference<EntryHolder>[] tables) {
        boolean found;
        int startLevel = 0;
        int tableSize = tables.length >> 1;
        block0: while (true) {
            if (startLevel >= 10) {
                startLevel = 0;
            }
            found = false;
            int[] route = new int[10];
            int depth = startLevel;
            do {
                EntryHolder entryHolder = tables[entryIndex].get();
                while (entryHolder.markedForRelocation) {
                    this.helpRelocate(entryIndex, false, tables);
                    entryHolder = tables[entryIndex].get();
                }
                if (!this.entryIsEmpty(entryHolder)) {
                    route[depth] = entryIndex;
                    entryIndex = entryIndex < tableSize ? OThreadCountersHashTable.secondSubTableIndex(entryHolder.entry.hashCodes, tables.length) : OThreadCountersHashTable.firstSubTableIndex(entryHolder.entry.hashCodes, tables.length);
                    ++depth;
                    continue;
                }
                found = true;
            } while (!found && depth < 10);
            if (!found) break;
            for (int i = depth - 1; i >= 0; --i) {
                int index = route[i];
                EntryHolder entryHolder = tables[index].get();
                if (entryHolder.markedForRelocation) {
                    this.helpRelocate(index, false, tables);
                    entryHolder = tables[index].get();
                }
                if (this.entryIsEmpty(entryHolder)) continue;
                int destinationIndex = index < tableSize ? OThreadCountersHashTable.secondSubTableIndex(entryHolder.entry.hashCodes, tables.length) : OThreadCountersHashTable.firstSubTableIndex(entryHolder.entry.hashCodes, tables.length);
                EntryHolder destinationEntry = tables[destinationIndex].get();
                if (!this.entryIsEmpty(destinationEntry)) {
                    startLevel = i + 1;
                    entryIndex = destinationIndex;
                    continue block0;
                }
                if (this.helpRelocate(index, true, tables)) continue;
                startLevel = i + 1;
                entryIndex = destinationIndex;
                continue block0;
            }
            break;
        }
        return found;
    }

    private boolean helpRelocate(int entryIndex, boolean initiator, AtomicReference<EntryHolder>[] tables) {
        EntryHolder destinationHolder;
        EntryHolder src;
        block5: {
            long newCounter;
            int destinationIndex;
            int tableSize = tables.length >> 1;
            do {
                src = tables[entryIndex].get();
                while (initiator && !src.markedForRelocation) {
                    if (this.entryIsEmpty(src)) {
                        return true;
                    }
                    tables[entryIndex].compareAndSet(src, new EntryHolder(src.counter, src.entry, true));
                    src = tables[entryIndex].get();
                }
                if (!src.markedForRelocation) {
                    return true;
                }
                destinationIndex = entryIndex < tableSize ? OThreadCountersHashTable.secondSubTableIndex(src.entry.hashCodes, tables.length) : OThreadCountersHashTable.firstSubTableIndex(src.entry.hashCodes, tables.length);
                destinationHolder = tables[destinationIndex].get();
                if (!this.entryIsEmpty(destinationHolder)) break block5;
                long l = newCounter = destinationHolder.counter > src.counter ? destinationHolder.counter + 1L : src.counter + 1L;
            } while (src != tables[entryIndex].get() || !tables[destinationIndex].compareAndSet(destinationHolder, new EntryHolder(newCounter, src.entry, false)));
            tables[entryIndex].compareAndSet(src, new EntryHolder(src.counter + 1L, null, false));
            return true;
        }
        if (destinationHolder.entry == src.entry) {
            tables[entryIndex].compareAndSet(src, new EntryHolder(src.counter + 1L, null, false));
            return true;
        }
        tables[entryIndex].compareAndSet(src, new EntryHolder(src.counter, src.entry, false));
        return false;
    }

    @Override
    public void onShutdown() {
        this.hashEntry = null;
    }

    @Override
    public void onStartup() {
        if (this.hashEntry == null) {
            this.hashEntry = new ThreadLocal();
        }
    }

    private static int secondSubTableIndex(int[] hashCodes, int size) {
        int subTableSize = size >> 1;
        return (hashCodes[1] & subTableSize - 1) + subTableSize;
    }

    private static int firstSubTableIndex(int[] hashCodes, int size) {
        return hashCodes[0] & (size >> 1) - 1;
    }

    private static int[] hashCodesByThreadId(long threadId) {
        byte[] serializedId = new byte[8];
        OLongSerializer.INSTANCE.serializeNative(threadId, serializedId, 0, new Object[0]);
        long hashCode = OMurmurHash3.murmurHash3_x64_64(serializedId, 362498820);
        return new int[]{(int)(hashCode & 0xFFFFFFFFL), (int)(hashCode >>> 32)};
    }

    private static final class FindResult {
        private final boolean found;
        private final boolean firstTable;
        private final EntryHolder firstEntryHolder;
        private final EntryHolder secondEntryHolder;

        private FindResult(boolean found, boolean firstTable, EntryHolder firstEntryHolder, EntryHolder secondEntryHolder) {
            this.found = found;
            this.firstTable = firstTable;
            this.firstEntryHolder = firstEntryHolder;
            this.secondEntryHolder = secondEntryHolder;
        }
    }

    private static final class EntryHolder {
        private final long counter;
        private final HashEntry entry;
        private final boolean markedForRelocation;

        private EntryHolder(long counter, HashEntry entry, boolean markedForRelocation) {
            this.counter = counter;
            this.entry = entry;
            this.markedForRelocation = markedForRelocation;
        }
    }

    static final class HashEntry {
        private final Thread thread;
        private final int[] hashCodes;
        private volatile long p0 = 0L;
        private volatile long p1 = 1L;
        private volatile long p2 = 2L;
        private volatile long p3 = 3L;
        private volatile long p4 = 4L;
        private volatile long p5 = 5L;
        private volatile long p6 = 6L;
        private volatile long p7 = 7L;
        private volatile long threadCounter = 0L;
        private volatile long p8 = 0L;
        private volatile long p9 = 1L;
        private volatile long p10 = 2L;
        private volatile long p11 = 3L;
        private volatile long p12 = 4L;
        private volatile long p13 = 5L;
        private volatile long p14 = 6L;

        private HashEntry(Thread thread, int[] hashCodes) {
            this.thread = thread;
            this.hashCodes = hashCodes;
        }

        public Thread getThread() {
            return this.thread;
        }

        public String toString() {
            this.modCounters();
            return "HashEntry{thread=" + this.thread + ", hashCodes=" + Arrays.toString(this.hashCodes) + ", p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + ", p3=" + this.p3 + ", p4=" + this.p4 + ", p5=" + this.p5 + ", p6=" + this.p6 + ", p7=" + this.p7 + ", threadCounter=" + this.threadCounter + ", p8=" + this.p8 + ", p9=" + this.p9 + ", p10=" + this.p10 + ", p11=" + this.p11 + ", p12=" + this.p12 + ", p13=" + this.p13 + ", p14=" + this.p14 + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashEntry hashEntry = (HashEntry)o;
            if (this.p1 != hashEntry.p1) {
                return false;
            }
            if (this.p10 != hashEntry.p10) {
                return false;
            }
            if (this.p11 != hashEntry.p11) {
                return false;
            }
            if (this.p12 != hashEntry.p12) {
                return false;
            }
            if (this.p13 != hashEntry.p13) {
                return false;
            }
            if (this.p14 != hashEntry.p14) {
                return false;
            }
            if (this.p2 != hashEntry.p2) {
                return false;
            }
            if (this.p3 != hashEntry.p3) {
                return false;
            }
            if (this.p4 != hashEntry.p4) {
                return false;
            }
            if (this.p5 != hashEntry.p5) {
                return false;
            }
            if (this.p6 != hashEntry.p6) {
                return false;
            }
            if (this.p7 != hashEntry.p7) {
                return false;
            }
            if (this.p8 != hashEntry.p8) {
                return false;
            }
            if (this.p9 != hashEntry.p9) {
                return false;
            }
            if (this.p0 != hashEntry.p0) {
                return false;
            }
            if (this.threadCounter != hashEntry.threadCounter) {
                return false;
            }
            if (!Arrays.equals(this.hashCodes, hashEntry.hashCodes)) {
                return false;
            }
            return !(this.thread != null ? !this.thread.equals(hashEntry.thread) : hashEntry.thread != null);
        }

        private void modCounters() {
            Random random = new Random();
            this.p0 = random.nextLong();
            this.p1 = random.nextLong();
            this.p2 = random.nextLong();
            this.p3 = random.nextLong();
            this.p4 = random.nextLong();
            this.p5 = random.nextLong();
            this.p6 = random.nextLong();
            this.p7 = random.nextLong();
            this.p8 = random.nextLong();
            this.p9 = random.nextLong();
            this.p10 = random.nextLong();
            this.p11 = random.nextLong();
            this.p12 = random.nextLong();
            this.p13 = random.nextLong();
            this.p14 = random.nextLong();
        }

        public int hashCode() {
            int result = this.thread != null ? this.thread.hashCode() : 0;
            result = 31 * result + (this.hashCodes != null ? Arrays.hashCode(this.hashCodes) : 0);
            result = 31 * result + (int)(this.p0 ^ this.p0 >>> 32);
            result = 31 * result + (int)(this.p1 ^ this.p1 >>> 32);
            result = 31 * result + (int)(this.p2 ^ this.p2 >>> 32);
            result = 31 * result + (int)(this.p3 ^ this.p3 >>> 32);
            result = 31 * result + (int)(this.p4 ^ this.p4 >>> 32);
            result = 31 * result + (int)(this.p5 ^ this.p5 >>> 32);
            result = 31 * result + (int)(this.p6 ^ this.p6 >>> 32);
            result = 31 * result + (int)(this.p7 ^ this.p7 >>> 32);
            result = 31 * result + (int)(this.threadCounter ^ this.threadCounter >>> 32);
            result = 31 * result + (int)(this.p8 ^ this.p8 >>> 32);
            result = 31 * result + (int)(this.p9 ^ this.p9 >>> 32);
            result = 31 * result + (int)(this.p10 ^ this.p10 >>> 32);
            result = 31 * result + (int)(this.p11 ^ this.p11 >>> 32);
            result = 31 * result + (int)(this.p12 ^ this.p12 >>> 32);
            result = 31 * result + (int)(this.p13 ^ this.p13 >>> 32);
            result = 31 * result + (int)(this.p14 ^ this.p14 >>> 32);
            return result;
        }
    }
}

