/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ONewLockManager<T> {
    private static final int CONCURRENCY_LEVEL = ONewLockManager.closestInteger(Runtime.getRuntime().availableProcessors() * 64);
    private static final int MASK = CONCURRENCY_LEVEL - 1;
    private final ReadWriteLock[] locks;
    private final OReadersWriterSpinLock[] spinLocks;
    private final boolean useSpinLock;

    public ONewLockManager() {
        this(false);
    }

    public ONewLockManager(boolean useSpinLock) {
        this.useSpinLock = useSpinLock;
        if (useSpinLock) {
            OReadersWriterSpinLock[] lcks = new OReadersWriterSpinLock[CONCURRENCY_LEVEL];
            for (int i = 0; i < lcks.length; ++i) {
                lcks[i] = new OReadersWriterSpinLock();
            }
            this.spinLocks = lcks;
            this.locks = null;
        } else {
            ReadWriteLock[] lcks = new ReadWriteLock[CONCURRENCY_LEVEL];
            for (int i = 0; i < lcks.length; ++i) {
                lcks[i] = new ReentrantReadWriteLock();
            }
            this.locks = lcks;
            this.spinLocks = null;
        }
    }

    private static int closestInteger(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    private static int longHashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    private static int index(int hashCode) {
        return hashCode & MASK;
    }

    public Lock acquireExclusiveLock(long value) {
        int hashCode = ONewLockManager.longHashCode(value);
        int index = ONewLockManager.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireWriteLock();
            return new SpinLockWrapper(false, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.lock();
        return lock;
    }

    public Lock acquireExclusiveLock(int value) {
        int index = ONewLockManager.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireWriteLock();
            return new SpinLockWrapper(false, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.lock();
        return lock;
    }

    public Lock acquireExclusiveLock(T value) {
        int index = value == null ? 0 : ONewLockManager.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireWriteLock();
            return new SpinLockWrapper(false, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.lock();
        return lock;
    }

    public void lockAllExclusive() {
        if (this.useSpinLock) {
            for (OReadersWriterSpinLock spinLock : this.spinLocks) {
                spinLock.acquireWriteLock();
            }
        } else {
            for (ReadWriteLock readWriteLock : this.locks) {
                readWriteLock.writeLock().lock();
            }
        }
    }

    public void unlockAllExclusive() {
        if (this.useSpinLock) {
            for (OReadersWriterSpinLock spinLock : this.spinLocks) {
                spinLock.releaseWriteLock();
            }
        } else {
            for (ReadWriteLock readWriteLock : this.locks) {
                readWriteLock.writeLock().unlock();
            }
        }
    }

    public boolean tryAcquireExclusiveLock(T value, long timeout) throws InterruptedException {
        if (this.useSpinLock) {
            throw new IllegalStateException("Spin lock does not support try lock mode");
        }
        int index = value == null ? 0 : ONewLockManager.index(value.hashCode());
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        return lock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    public void acquireExclusiveLocksInBatch(T ... value) {
        if (value == null) {
            return;
        }
        T[] values = Arrays.copyOf(value, value.length);
        Arrays.sort(values, 0, values.length, new Comparator<T>(){

            @Override
            public int compare(T one, T two) {
                int indexTwo;
                int indexOne = one == null ? 0 : ONewLockManager.index(one.hashCode());
                if (indexOne > (indexTwo = two == null ? 0 : ONewLockManager.index(two.hashCode()))) {
                    return 1;
                }
                if (indexOne < indexTwo) {
                    return -1;
                }
                return 0;
            }
        });
        for (T val : values) {
            this.acquireExclusiveLock(val);
        }
    }

    public void acquireExclusiveLocksInBatch(Collection<T> values) {
        if (values == null) {
            return;
        }
        ArrayList<T> valCopy = new ArrayList<T>(values);
        Collections.sort(valCopy, new Comparator<T>(){

            @Override
            public int compare(T one, T two) {
                int indexTwo;
                int indexOne = one == null ? 0 : ONewLockManager.index(one.hashCode());
                if (indexOne > (indexTwo = two == null ? 0 : ONewLockManager.index(two.hashCode()))) {
                    return 1;
                }
                if (indexOne < indexTwo) {
                    return -1;
                }
                return 0;
            }
        });
        for (Object val : valCopy) {
            this.acquireExclusiveLock(val);
        }
    }

    public Lock acquireSharedLock(long value) {
        int hashCode = ONewLockManager.longHashCode(value);
        int index = ONewLockManager.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireReadLock();
            return new SpinLockWrapper(true, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.lock();
        return lock;
    }

    public boolean tryAcquireSharedLock(T value, long timeout) throws InterruptedException {
        if (this.useSpinLock) {
            throw new IllegalStateException("Spin lock does not support try lock mode");
        }
        int index = value == null ? 0 : ONewLockManager.index(value.hashCode());
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        return lock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    public Lock acquireSharedLock(int value) {
        int index = ONewLockManager.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireReadLock();
            return new SpinLockWrapper(true, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.lock();
        return lock;
    }

    public Lock acquireSharedLock(T value) {
        int index = value == null ? 0 : ONewLockManager.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireReadLock();
            return new SpinLockWrapper(true, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.lock();
        return lock;
    }

    public void releaseSharedLock(int value) {
        int index = ONewLockManager.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseReadLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        rwLock.readLock().unlock();
    }

    public void releaseSharedLock(long value) {
        int hashCode = ONewLockManager.longHashCode(value);
        int index = ONewLockManager.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseReadLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.unlock();
    }

    public void releaseSharedLock(T value) {
        int index = value == null ? 0 : ONewLockManager.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseReadLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.unlock();
    }

    public void releaseExclusiveLock(int value) {
        int index = ONewLockManager.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseWriteLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        rwLock.writeLock().unlock();
    }

    public void releaseExclusiveLock(long value) {
        int hashCode = ONewLockManager.longHashCode(value);
        int index = ONewLockManager.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseWriteLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.unlock();
    }

    public void releaseExclusiveLock(T value) {
        int index = value == null ? 0 : ONewLockManager.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseWriteLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.unlock();
    }

    public void releaseLock(Lock lock) {
        lock.unlock();
    }

    private static final class SpinLockWrapper
    implements Lock {
        private final boolean readLock;
        private final OReadersWriterSpinLock spinLock;

        private SpinLockWrapper(boolean readLock, OReadersWriterSpinLock spinLock) {
            this.readLock = readLock;
            this.spinLock = spinLock;
        }

        @Override
        public void lock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            if (this.readLock) {
                this.spinLock.releaseReadLock();
            } else {
                this.spinLock.releaseWriteLock();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

