/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.sosl;

import apex.jorje.data.sosl.DivisionValue;
import apex.jorje.data.sosl.WithDivisionClause;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;

public class WithDivisionPrinter
implements Printer<WithDivisionClause> {
    private final PrinterFactory factory;

    public WithDivisionPrinter(PrinterFactory factory) {
        this.factory = factory;
    }

    @Override
    public String print(WithDivisionClause x, final PrintContext ctx) {
        return "WITH DIVISION = " + x.value.match(new DivisionValue.MatchBlock<String>(){

            @Override
            public String _case(DivisionValue.DivisionLiteral x) {
                return "'" + x.literal + "'";
            }

            @Override
            public String _case(DivisionValue.DivisionExpr x) {
                return WithDivisionPrinter.this.factory.colonExprPrinter().print(x.expr, ctx);
            }
        });
    }
}

