/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.ast.Identifier;
import apex.jorje.data.soql.SelectExpr;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.StandardPrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;

public class SelectExprPrinter
implements Printer<SelectExpr> {
    private static final Set<String> AGGREGATE_FUNCTIONS = Sets.newHashSet("AVG", "COUNT", "COUNT_DISTINCT", "MIN", "MAX", "SUM");
    private final StandardPrinterFactory factory;

    public SelectExprPrinter(StandardPrinterFactory factory) {
        this.factory = factory;
    }

    @Override
    public String print(SelectExpr x, final PrintContext ctx) {
        final Printer<Optional<Identifier>> optionalAlias = OptionalPrinter.create(this.factory.identifierPrinter(), "", " ", "");
        return x.match(new SelectExpr.MatchBlock<String>(){

            @Override
            public String _case(SelectExpr.SelectCaseExpr x) {
                return SelectExprPrinter.this.factory.caseExprPrinter().print(x.caseExpr, ctx) + optionalAlias.print(x.alias, ctx);
            }

            @Override
            public String _case(SelectExpr.SelectColumnExpr x) {
                ctx.checkAggregate(SelectExprPrinter.this.isAggregate(x.field.function1));
                ctx.checkAggregate(SelectExprPrinter.this.isAggregate(x.field.function2));
                return SelectExprPrinter.this.factory.fieldPrinter().print(x.field, ctx) + optionalAlias.print(x.alias, ctx);
            }

            @Override
            public String _case(SelectExpr.SelectInnerQuery x) {
                return "(" + SelectExprPrinter.this.factory.queryPrinter().print(x.query, ctx) + ")" + optionalAlias.print(x.alias, ctx);
            }
        });
    }

    private boolean isAggregate(Optional<Identifier> function) {
        return function.map(value -> AGGREGATE_FUNCTIONS.contains(value.value.toUpperCase())).orElse(false);
    }
}

