/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.DistanceFunctionExpr;
import apex.jorje.data.soql.Geolocation;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;

public class DistanceFunctionExprPrinter
implements Printer<DistanceFunctionExpr> {
    private final PrinterFactory factory;

    public DistanceFunctionExprPrinter(PrinterFactory factory) {
        this.factory = factory;
    }

    @Override
    public String print(DistanceFunctionExpr x, final PrintContext ctx) {
        String location = x.location.match(new Geolocation.MatchBlock<String>(){

            @Override
            public String _case(Geolocation.GeolocationLiteral x) {
                return x.latitude + ", " + x.longitude;
            }

            @Override
            public String _case(Geolocation.GeolocationExpr x) {
                return DistanceFunctionExprPrinter.this.factory.colonExprPrinter().print(x.expr, ctx);
            }
        });
        return "DISTANCE(" + this.factory.fieldIdentifierPrinter().print(x.field, ctx) + ", GEOLOCATION(" + location + "), '" + x.unit + "')";
    }
}

