/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.JavaRef;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.List;
import java.util.Optional;

public class TypeRefPrinter
implements Printer<TypeRef> {
    private final Printer<Iterable<Identifier>> dottedIdentifierPrinter;
    private final Printer<Optional<JavaRef>> javaRefPrinter;
    private final Printer<Optional<Iterable<TypeRef>>> optionalTypeListPrinter;

    public TypeRefPrinter(Printer<Iterable<Identifier>> dottedIdentifierPrinter, Printer<Optional<JavaRef>> javaRefPrinter) {
        this.dottedIdentifierPrinter = dottedIdentifierPrinter;
        this.javaRefPrinter = javaRefPrinter;
        Printer<Iterable<TypeRef>> typeListPrinter = ListPrinter.create(this, ", ", "<", ">");
        this.optionalTypeListPrinter = OptionalPrinter.create(typeListPrinter, "", "", "");
    }

    @Override
    public String print(TypeRef typeRef, final PrintContext ctx) {
        return typeRef.match(new TypeRef.MatchBlock<String>(){

            @Override
            public String _case(TypeRef.ClassTypeRef x) {
                String javaRef = TypeRefPrinter.this.javaRefPrinter.print(x.javaRef, ctx);
                Optional<List<TypeRef>> typeArguments = x.typeArguments;
                return javaRef + TypeRefPrinter.this.dottedIdentifierPrinter.print(x.className, ctx) + TypeRefPrinter.this.optionalTypeListPrinter.print(typeArguments, ctx);
            }

            @Override
            public String _case(TypeRef.ArrayTypeRef x) {
                return x.heldType.match(this) + "[]";
            }
        });
    }
}

