/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.PropertyGetter;
import apex.jorje.data.ast.PropertySetter;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.Optional;

public class PropertyDeclPrinter
implements Printer<PropertyDecl> {
    private final PrinterFactory factory;
    private final Printer<Iterable<Modifier>> modifiersPrinter;
    private final String indent;
    private final Printer<TypeRef> typeRefPrinter;
    private final Printer<Identifier> identifierPrinter;

    public PropertyDeclPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.modifiersPrinter = factory.modifiersPrinter();
        this.indent = factory.indent();
        this.typeRefPrinter = factory.typeRefPrinter();
        this.identifierPrinter = factory.identifierPrinter();
    }

    @Override
    public String print(PropertyDecl x, PrintContext ctx) {
        Printer<Optional<PropertyGetter>> optionalGetterPrinter = OptionalPrinter.create(this.factory.nestedPrinterFactory().propertyGetterPrinter(), "", "", "");
        Printer<Optional<PropertySetter>> optionalSetterPrinter = OptionalPrinter.create(this.factory.nestedPrinterFactory().propertySetterPrinter(), "", "", "");
        return this.indent + this.modifiersPrinter.print(x.modifiers, ctx) + this.typeRefPrinter.print(x.type, ctx) + " " + this.identifierPrinter.print(x.name, ctx) + " " + "{\n" + optionalGetterPrinter.print(x.getter, ctx) + optionalSetterPrinter.print(x.setter, ctx) + this.indent + "}";
    }
}

