/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.PrefixOp;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;

public class PrefixOpPrinter
implements Printer<PrefixOp> {
    private final Printer<TypeRef> typeRefPrinter;

    public PrefixOpPrinter(Printer<TypeRef> typeRefPrinter) {
        this.typeRefPrinter = typeRefPrinter;
    }

    @Override
    public String print(PrefixOp op, final PrintContext ctx) {
        return op.match(new PrefixOp.MatchBlock<String>(){

            @Override
            public String _case(PrefixOp.Positive x) {
                return "+";
            }

            @Override
            public String _case(PrefixOp.Negative x) {
                return "-";
            }

            @Override
            public String _case(PrefixOp.Not x) {
                return "!";
            }

            @Override
            public String _case(PrefixOp.BitwiseComplement x) {
                return "~";
            }

            @Override
            public String _case(PrefixOp.PrefixInc x) {
                return "++";
            }

            @Override
            public String _case(PrefixOp.PrefixDec x) {
                return "--";
            }

            @Override
            public String _case(PrefixOp.Cast x) {
                return "(" + PrefixOpPrinter.this.typeRefPrinter.print(x.type, ctx) + ")";
            }
        });
    }
}

