/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Stmnt;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import java.util.Optional;

public class OptionalNestedStatementPrinter
implements Printer<Optional<Stmnt>> {
    private final String indent;
    private final PrinterFactory currentLevelPrinterFactory;

    public OptionalNestedStatementPrinter(PrinterFactory factory) {
        this.currentLevelPrinterFactory = factory;
        this.indent = factory.indent();
    }

    @Override
    public String print(Optional<Stmnt> stmnt, final PrintContext ctx) {
        return stmnt.map(value -> {
            final Printer<Stmnt> nextLevelPrinter = this.currentLevelPrinterFactory.nestedPrinterFactory().stmntPrinter();
            return value.match(new Stmnt.MatchBlockWithDefault<String>(){

                @Override
                public String _case(Stmnt.BlockStmnt x) {
                    StringBuilder builder = new StringBuilder("{\n");
                    for (Stmnt stmnt : x.stmnts.values) {
                        builder.append(nextLevelPrinter.print(stmnt, ctx));
                        builder.append("\n");
                    }
                    builder.append(OptionalNestedStatementPrinter.this.indent).append("} ");
                    return builder.toString();
                }

                @Override
                protected String _default(Stmnt x) {
                    return "\n" + nextLevelPrinter.print(x, ctx) + "\n";
                }
            });
        }).orElse(";\n");
    }
}

