/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.NameValueParameter;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.Optional;
import java.util.stream.Collectors;

public class ObjectCreatorPrinter
implements Printer<ObjectCreator> {
    private final PrinterFactory factory;
    private final Printer<Expr> exprPrinter;
    private final Printer<TypeRef> typeRefPrinter;
    private final Printer<Optional<Expr>> optionalExpr;
    private final Printer<Iterable<TypeRef>> typeListPrinter;
    private final Printer<Iterable<NameValueParameter>> sObjectParameterListPrinter;

    public ObjectCreatorPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.exprPrinter = factory.exprPrinter();
        this.typeRefPrinter = factory.typeRefPrinter();
        this.optionalExpr = OptionalPrinter.create(this.exprPrinter, "", "", "");
        this.typeListPrinter = ListPrinter.create(this.typeRefPrinter, ", ", "<", ">");
        this.sObjectParameterListPrinter = ListPrinter.create(factory.nameValueParameter(), ", ", "(", ")");
    }

    @Override
    public String print(ObjectCreator x, final PrintContext ctx) {
        return x.match(new ObjectCreator.MatchBlock<String>(){

            @Override
            public String _case(ObjectCreator.ListInitCreator x) {
                return "List" + ObjectCreatorPrinter.this.typeListPrinter.print(x.types, ctx) + "(" + ObjectCreatorPrinter.this.optionalExpr.print(x.expr, ctx) + ")";
            }

            @Override
            public String _case(ObjectCreator.ListLiteralCreator x) {
                return "List" + ObjectCreatorPrinter.this.typeListPrinter.print(x.types, ctx) + "{" + ObjectCreatorPrinter.this.factory.exprListPrinter().print(x.values.values, ctx) + "}";
            }

            @Override
            public String _case(ObjectCreator.SetInitCreator x) {
                return "Set" + ObjectCreatorPrinter.this.typeListPrinter.print(x.types, ctx) + "(" + ObjectCreatorPrinter.this.optionalExpr.print(x.expr, ctx) + ")";
            }

            @Override
            public String _case(ObjectCreator.SetLiteralCreator x) {
                return "Set" + ObjectCreatorPrinter.this.typeListPrinter.print(x.types, ctx) + "{" + ObjectCreatorPrinter.this.factory.exprListPrinter().print(x.values.values, ctx) + "}";
            }

            @Override
            public String _case(ObjectCreator.MapInitCreator x) {
                return "Map" + ObjectCreatorPrinter.this.typeListPrinter.print(x.types, ctx) + "(" + ObjectCreatorPrinter.this.optionalExpr.print(x.expr, ctx) + ")";
            }

            @Override
            public String _case(ObjectCreator.MapLiteralCreator x) {
                return "Map" + ObjectCreatorPrinter.this.typeListPrinter.print(x.types, ctx) + x.pairs.values.stream().map(keyValue -> ObjectCreatorPrinter.this.exprPrinter.print(keyValue.key, ctx) + " => " + ObjectCreatorPrinter.this.exprPrinter.print(keyValue.value, ctx)).collect(Collectors.joining(", ", "{", "}"));
            }

            @Override
            public String _case(ObjectCreator.NameValueCreator x) {
                return ObjectCreatorPrinter.this.typeRefPrinter.print(x.type, ctx) + ObjectCreatorPrinter.this.sObjectParameterListPrinter.print(x.keyValues.values, ctx);
            }

            @Override
            public String _case(ObjectCreator.NormalObjectCreator x) {
                return ObjectCreatorPrinter.this.typeRefPrinter.print(x.type, ctx) + "(" + ObjectCreatorPrinter.this.factory.exprListPrinter().print(x.inputParameters.values, ctx) + ")";
            }
        });
    }
}

