/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Literal;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;

public class LiteralPrinter
implements Printer<Literal> {
    @Override
    public String print(Literal x, PrintContext ctx) {
        return x.match(new Literal.MatchBlock<String>(){

            @Override
            public String _case(Literal.StringLiteral x) {
                return "'" + x.literal + "'";
            }

            @Override
            public String _case(Literal.IntegerLiteral x) {
                return x.literal.toString();
            }

            @Override
            public String _case(Literal.LongLiteral x) {
                return x.literal + "L";
            }

            @Override
            public String _case(Literal.DoubleLiteral x) {
                return x.literal + "D";
            }

            @Override
            public String _case(Literal.DecimalLiteral x) {
                return x.literal.toString();
            }

            @Override
            public String _case(Literal.NullLiteral x) {
                return "null";
            }

            @Override
            public String _case(Literal.TrueLiteral x) {
                return "true";
            }

            @Override
            public String _case(Literal.FalseLiteral x) {
                return "false";
            }
        });
    }
}

