/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.Optional;
import java.util.stream.Collectors;

public class ForControlPrinter
implements Printer<ForControl> {
    private final PrinterFactory factory;
    private final Printer<TypeRef> typeRefPrinter;
    private final Printer<Identifier> identifierPrinter;

    public ForControlPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.typeRefPrinter = factory.typeRefPrinter();
        this.identifierPrinter = factory.identifierPrinter();
    }

    @Override
    public String print(ForControl x, final PrintContext ctx) {
        final Printer<Optional<Expr>> optionalExpr = OptionalPrinter.create(this.factory.exprPrinter(), "", " ", "");
        return x.match(new ForControl.MatchBlock<String>(){

            @Override
            public String _case(ForControl.EnhancedForControl x) {
                StringBuilder builder = new StringBuilder();
                x.type.ifPresent(value -> builder.append(ForControlPrinter.this.typeRefPrinter.print(value, ctx)).append(" "));
                builder.append(ForControlPrinter.this.identifierPrinter.print(x.init.name, ctx)).append(" : ").append(ForControlPrinter.this.factory.exprPrinter().print(x.init.expr, ctx));
                return builder.toString();
            }

            @Override
            public String _case(ForControl.CStyleForControl x) {
                StringBuilder builder = new StringBuilder();
                x.inits.ifPresent(value -> {
                    value.type.ifPresent(type -> builder.append(ForControlPrinter.this.typeRefPrinter.print(type, ctx)).append(" "));
                    builder.append(value.inits.stream().map(init -> ForControlPrinter.this.identifierPrinter.print(init.name, ctx) + " = " + ForControlPrinter.this.factory.exprPrinter().print(init.expr, ctx)).collect(Collectors.joining(", ")));
                });
                builder.append(";");
                builder.append(optionalExpr.print(x.condition, ctx));
                builder.append(";");
                builder.append(optionalExpr.print(x.control, ctx));
                return builder.toString();
            }
        });
    }
}

