/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;

public class CompilationUnitPrinter
implements Printer<CompilationUnit> {
    private final PrinterFactory factory;
    private final Printer<Identifier> identifierPrinter;
    private final Printer<GroupedList<TriggerUsage>> triggerUsagesPrinter;

    public CompilationUnitPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.identifierPrinter = factory.identifierPrinter();
        this.triggerUsagesPrinter = factory.triggerUsagesPrinter();
    }

    @Override
    public String print(CompilationUnit x, final PrintContext ctx) {
        return x.match(new CompilationUnit.MatchBlock<String>(){

            @Override
            public String _case(CompilationUnit.TriggerDeclUnit x) {
                StringBuilder builder = new StringBuilder();
                builder.append(CompilationUnitPrinter.this.factory.indent());
                builder.append("trigger ");
                builder.append(CompilationUnitPrinter.this.identifierPrinter.print(x.name, ctx));
                builder.append(" on ");
                builder.append(CompilationUnitPrinter.this.identifierPrinter.print(x.target, ctx));
                builder.append(" ");
                builder.append(x.bulk.map(triggerBulk -> "bulk ").orElse(""));
                builder.append(CompilationUnitPrinter.this.triggerUsagesPrinter.print(x.usages, ctx));
                builder.append(" {\n");
                Printer<Iterable<BlockMember>> listMemberPrinter = ListPrinter.create(CompilationUnitPrinter.this.factory.nestedPrinterFactory().blockMemberPrinter(), "\n", "", "\n");
                builder.append(listMemberPrinter.print(x.members.values, ctx));
                builder.append(CompilationUnitPrinter.this.factory.indent());
                builder.append("}");
                return builder.toString();
            }

            @Override
            public String _case(CompilationUnit.AnonymousBlockUnit x) {
                return ListPrinter.create(CompilationUnitPrinter.this.factory.blockMemberPrinter(), "\n", "", "").print(x.members, ctx);
            }

            @Override
            public String _case(CompilationUnit.EnumDeclUnit x) {
                return CompilationUnitPrinter.this.factory.enumDeclPrinter().print(x.body, ctx);
            }

            @Override
            public String _case(CompilationUnit.ClassDeclUnit x) {
                return CompilationUnitPrinter.this.factory.classDeclPrinter().print(x.body, ctx);
            }

            @Override
            public String _case(CompilationUnit.InterfaceDeclUnit x) {
                return CompilationUnitPrinter.this.factory.interfaceDeclPrinter().print(x.body, ctx);
            }

            @Override
            public String _case(CompilationUnit.InvalidDeclUnit x) {
                return "invalid decl unit";
            }
        });
    }
}

