/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.MethodDecl;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import java.util.Optional;

public class BlockMemberPrinter
implements Printer<BlockMember> {
    private final PrinterFactory factory;
    private final Printer<MethodDecl> methodDeclPrinter;
    private final Printer<VariableDecls> variableDeclsPrinter;
    private final Printer<PropertyDecl> propertyDeclPrinter;

    public BlockMemberPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.methodDeclPrinter = factory.methodDeclPrinter();
        this.variableDeclsPrinter = factory.variableDeclsPrinter();
        this.propertyDeclPrinter = factory.propertyDeclPrinter();
    }

    @Override
    public String print(BlockMember x, final PrintContext ctx) {
        return x.match(new BlockMember.MatchBlock<String>(){

            @Override
            public String _case(BlockMember.StmntBlockMember x) {
                return BlockMemberPrinter.this.factory.stmntPrinter().print(x.stmnt, ctx);
            }

            @Override
            public String _case(BlockMember.StaticStmntBlockMember x) {
                return BlockMemberPrinter.this.factory.indent() + "static " + BlockMemberPrinter.this.factory.optionalNestedStmntPrinter().print(Optional.of(x.stmnt), ctx);
            }

            @Override
            public String _case(BlockMember.FieldMember x) {
                return BlockMemberPrinter.this.variableDeclsPrinter.print(x.variableDecls, ctx);
            }

            @Override
            public String _case(BlockMember.MethodMember x) {
                return BlockMemberPrinter.this.methodDeclPrinter.print(x.methodDecl, ctx);
            }

            @Override
            public String _case(BlockMember.PropertyMember x) {
                return BlockMemberPrinter.this.propertyDeclPrinter.print(x.propertyDecl, ctx);
            }

            @Override
            public String _case(BlockMember.InnerClassMember x) {
                return BlockMemberPrinter.this.factory.classDeclPrinter().print(x.body, ctx);
            }

            @Override
            public String _case(BlockMember.InnerInterfaceMember x) {
                return BlockMemberPrinter.this.factory.interfaceDeclPrinter().print(x.body, ctx);
            }

            @Override
            public String _case(BlockMember.InnerEnumMember x) {
                return BlockMemberPrinter.this.factory.enumDeclPrinter().print(x.body, ctx);
            }
        });
    }
}

