/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.AnnotationParameter;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.data.ast.Identifier;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;

public class AnnotationParameterPrinter
implements Printer<AnnotationParameter> {
    private final Printer<Identifier> identifierPrinter;

    public AnnotationParameterPrinter(Printer<Identifier> identifierPrinter) {
        this.identifierPrinter = identifierPrinter;
    }

    @Override
    public String print(AnnotationParameter x, final PrintContext ctx) {
        return x.match(new AnnotationParameter.MatchBlock<String>(){

            @Override
            public String _case(AnnotationParameter.AnnotationString x) {
                return "'" + x.value + "'";
            }

            @Override
            public String _case(AnnotationParameter.AnnotationKeyValue x) {
                return AnnotationParameterPrinter.this.identifierPrinter.print(x.key, ctx) + "=" + x.value.match(new AnnotationValue.MatchBlock<String>(){

                    @Override
                    public String _case(AnnotationValue.TrueAnnotationValue x) {
                        return "true";
                    }

                    @Override
                    public String _case(AnnotationValue.FalseAnnotationValue x) {
                        return "false";
                    }

                    @Override
                    public String _case(AnnotationValue.StringAnnotationValue x) {
                        return "'" + x.value + "'";
                    }
                });
            }
        });
    }
}

