/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.data.sosl.Search;
import com.google.common.collect.Lists;
import java.util.List;

public class PrintContext {
    private final List<BindExpr> bindExprs = Lists.newArrayList();
    private boolean isCountQuery = false;
    private FieldIdentifier entity = null;
    private boolean isAggregate = false;
    private boolean forUpdate = false;
    private Search search;
    private int queryDepth = 0;

    public FieldIdentifier getEntity() {
        return this.entity;
    }

    public void setEntity(FieldIdentifier entity) {
        this.entity = entity;
    }

    public boolean isCountQuery() {
        return this.isCountQuery;
    }

    public void setIsCountQuery(boolean isCountQuery) {
        this.isCountQuery = isCountQuery;
    }

    public String addBindExpr(Expr expr) {
        String name = "tmpVar" + (this.bindExprs.size() + 1);
        this.bindExprs.add(new BindExpr(name, expr));
        return name;
    }

    public List<BindExpr> getBindExprs() {
        return this.bindExprs;
    }

    public void checkAggregate(boolean isAggregate) {
        this.isAggregate |= isAggregate;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public Search getSearch() {
        return this.search;
    }

    public void setSearch(Search search) {
        this.search = search;
    }

    public void pushQueryDepth() {
        ++this.queryDepth;
    }

    public int getQueryDepth() {
        return this.queryDepth;
    }

    public void popQueryDepth() {
        --this.queryDepth;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public static class BindExpr {
        public final String name;
        public final Expr expr;

        public BindExpr(String name, Expr expr) {
            this.name = name;
            this.expr = expr;
        }
    }
}

