/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers;

import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import com.google.common.collect.Iterables;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ListPrinter<T>
implements Printer<Iterable<T>> {
    private final Printer<T> elementPrinter;
    private final String separator;
    private final String nonEmptyTrailer;
    private final String nonEmptyPredecessor;

    private ListPrinter(Printer<T> elementPrinter, String separator, String nonEmptyPredecessor, String nonEmptyTrailer) {
        this.elementPrinter = elementPrinter;
        this.separator = separator;
        this.nonEmptyTrailer = nonEmptyTrailer;
        this.nonEmptyPredecessor = nonEmptyPredecessor;
    }

    public static <T> Printer<Iterable<T>> create(Printer<T> elementPrinter, String separator, String nonEmptyPredecessor, String nonEmptyTrailer) {
        return new ListPrinter<T>(elementPrinter, separator, nonEmptyPredecessor, nonEmptyTrailer);
    }

    @Override
    public String print(Iterable<T> elements, PrintContext ctx) {
        if (!Iterables.isEmpty(elements)) {
            return StreamSupport.stream(elements.spliterator(), false).map(element -> this.elementPrinter.print(element, ctx)).collect(Collectors.joining(this.separator, this.nonEmptyPredecessor, this.nonEmptyTrailer));
        }
        return "";
    }
}

