/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.exception;

import apex.jorje.data.Loc;
import apex.jorje.data.errors.UserError;
import apex.jorje.services.Location;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;

public class ParseException
extends CompilationException {
    private final UserError error;

    private ParseException(UserError error, Throwable cause) {
        super(error.toString(), cause);
        this.error = error;
    }

    public static ParseException create(UserError error, Throwable cause) {
        return new ParseException(error, cause);
    }

    public UserError getUserError() {
        return this.error;
    }

    @Override
    public String getError() {
        return PrinterUtil.get().getFactory().userErrorPrinter().print(this.error, new PrintContext());
    }

    @Override
    public Loc getLoc() {
        return Location.from(this.error);
    }
}

