/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.datetimes;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;

public final class DateTimeFormats {
    private static final ZoneId UTC;
    public static final DateTimeFormatter DATE;
    public static final DateTimeFormatter PRINT_DATE;
    public static final DateTimeFormatter PRINT_TIME;
    public static final DateTimeFormatter PRINT_DATE_TIME;
    private static final DateTimeFormatter BASE_TIME;
    private static final DateTimeFormatter TIME_NO_OFFSET;
    private static final DateTimeFormatter TIME_OFFSET;
    public static final DateTimeFormatter TIME;
    public static final DateTimeFormatter DATE_TIME;

    private DateTimeFormats() {
    }

    public static LocalDate fromDate(String literal) {
        return DATE.parse((CharSequence)literal, LocalDate::from);
    }

    public static OffsetTime fromTime(String literal) {
        TemporalAccessor ta = TIME.parseBest(literal, OffsetTime::from, LocalTime::from);
        if (ta instanceof OffsetTime) {
            return OffsetTime.from(ta).withOffsetSameInstant(ZoneOffset.UTC);
        }
        if (ta instanceof LocalTime) {
            return LocalTime.from(ta).atOffset(ZoneOffset.UTC);
        }
        throw new DateTimeException("Can't parse " + literal + " as OffsetTime");
    }

    public static ZonedDateTime fromDateTime(String literal) {
        return DATE_TIME.parse((CharSequence)literal, ZonedDateTime::from).withZoneSameInstant(UTC);
    }

    static {
        DATE = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM-dd")).toFormatter();
        PRINT_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        PRINT_TIME = DateTimeFormatter.ofPattern("HH:mm:ss.SSS'z'");
        PRINT_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd't'HH:mm:ss.SSS'z'");
        BASE_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("HH:mm:ss")).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').append(DateTimeFormatter.ofPattern("SSS")).toFormatter()).toFormatter();
        TIME_NO_OFFSET = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("z").parseCaseSensitive().toFormatter();
        TIME_OFFSET = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("Z")).toFormatter();
        TIME = new DateTimeFormatterBuilder().append(BASE_TIME).appendOptional(TIME_NO_OFFSET).appendOptional(TIME_OFFSET).toFormatter();
        DATE_TIME = new DateTimeFormatterBuilder().append(DATE).parseCaseInsensitive().appendLiteral('t').parseCaseSensitive().append(TIME).toFormatter();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        UTC = ZoneId.of("UTC");
    }
}

