/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.Literal;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TriggerAction;
import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.data.ast.TriggerWhen;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.errors.LexicalError;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import com.google.common.collect.Iterables;
import java.util.Optional;

public class Location {
    public static final Loc ANONYMOUS_BLOCK = Loc._RealLoc(0, 0, 1, 1);

    private Location() {
    }

    public static Loc from(Stmnt stmnt) {
        return stmnt == null ? Loc._SyntheticLoc() : stmnt.match(new Stmnt.MatchBlock<Loc>(){

            @Override
            public Loc _case(Stmnt.BlockStmnt x) {
                return Optional.ofNullable(x.stmnts).map(stmnts -> stmnts.loc).orElse(Loc._SyntheticLoc());
            }

            @Override
            public Loc _case(Stmnt.ExpressionStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.ReturnStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.ThrowStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.BreakStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.ContinueStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.DmlInsertStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.DmlUpdateStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.DmlUpsertStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.DmlDeleteStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.DmlUndeleteStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.DmlMergeStmnt x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.WhileLoop x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.DoLoop x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.IfElseBlock x) {
                assert (!x.ifBlocks.isEmpty());
                return Location.from(Location.from(x.ifBlocks.get(0)), Location.from(Iterables.getLast(x.ifBlocks)));
            }

            @Override
            public Loc _case(Stmnt.RunAsBlock x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.TryCatchFinallyBlock x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.VariableDeclStmnt x) {
                assert (!x.variableDecls.decls.isEmpty());
                return Location.from(Location.from(x.variableDecls.type), Location.from(Iterables.getLast(x.variableDecls.decls).name));
            }

            @Override
            public Loc _case(Stmnt.ForLoop x) {
                return x.loc;
            }

            @Override
            public Loc _case(Stmnt.SwitchStatement x) {
                return x.loc;
            }
        });
    }

    private static Loc from(IfBlock ifBlock) {
        return ifBlock == null ? Loc._SyntheticLoc() : ifBlock.loc;
    }

    public static Loc from(Expr expr) {
        return expr == null ? Loc._SyntheticLoc() : expr.match(new Expr.MatchBlock<Loc>(){

            @Override
            public Loc _case(Expr.AssignmentExpr x) {
                return Location.from(x.left);
            }

            @Override
            public Loc _case(Expr.TernaryExpr x) {
                return Location.from(x.condition);
            }

            @Override
            public Loc _case(Expr.PrefixExpr x) {
                return Location.from(x.expr);
            }

            @Override
            public Loc _case(Expr.BinaryExpr x) {
                return Location.from(x.left);
            }

            @Override
            public Loc _case(Expr.InstanceOf x) {
                return Location.from(x.expr);
            }

            @Override
            public Loc _case(Expr.BooleanExpr x) {
                return Location.from(x.left);
            }

            @Override
            public Loc _case(Expr.TriggerVariableExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.PackageVersionExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.PostfixExpr x) {
                return Location.from(x.expr);
            }

            @Override
            public Loc _case(Expr.ArrayExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.VariableExpr x) {
                assert (!x.names.isEmpty());
                return Location.from(x.names.get((int)0).loc, Iterables.getLast(x.names).loc);
            }

            @Override
            public Loc _case(Expr.MethodCallExpr x) {
                assert (!x.names.isEmpty());
                return Location.from(x.names.get((int)0).loc, Iterables.getLast(x.names).loc);
            }

            @Override
            public Loc _case(Expr.JavaMethodCallExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.JavaVariableExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.SuperMethodCallExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.SuperVariableExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.ThisMethodCallExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.ThisVariableExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.ClassRefExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.LiteralExpr x) {
                return Location.from(x.literal);
            }

            @Override
            public Loc _case(Expr.NewExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.NestedExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.SoqlExpr x) {
                return x.loc;
            }

            @Override
            public Loc _case(Expr.SoslExpr x) {
                return x.loc;
            }
        });
    }

    public static Loc from(Literal literal) {
        return literal == null ? Loc._SyntheticLoc() : literal.match(new Literal.MatchBlock<Loc>(){

            @Override
            public Loc _case(Literal.StringLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(Literal.IntegerLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(Literal.LongLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(Literal.DoubleLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(Literal.DecimalLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(Literal.NullLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(Literal.TrueLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(Literal.FalseLiteral x) {
                return x.loc;
            }
        });
    }

    public static Loc from(TypeRef tr) {
        return tr == null ? Loc._SyntheticLoc() : tr.match(new TypeRef.MatchBlock<Loc>(){

            @Override
            public Loc _case(TypeRef.ClassTypeRef x) {
                assert (!x.className.isEmpty());
                return Location.from(x.className.get((int)0).loc, Iterables.getLast(x.className).loc);
            }

            @Override
            public Loc _case(TypeRef.ArrayTypeRef x) {
                return x.loc;
            }
        });
    }

    public static Loc from(CompilationUnit cu) {
        return cu == null ? Loc._SyntheticLoc() : cu.match(new CompilationUnit.MatchBlock<Loc>(){

            @Override
            public Loc _case(CompilationUnit.TriggerDeclUnit x) {
                return x.name.loc;
            }

            @Override
            public Loc _case(CompilationUnit.AnonymousBlockUnit x) {
                return ANONYMOUS_BLOCK;
            }

            @Override
            public Loc _case(CompilationUnit.EnumDeclUnit x) {
                return x.body.name.loc;
            }

            @Override
            public Loc _case(CompilationUnit.ClassDeclUnit x) {
                return x.body.name.loc;
            }

            @Override
            public Loc _case(CompilationUnit.InterfaceDeclUnit x) {
                return x.body.name.loc;
            }

            @Override
            public Loc _case(CompilationUnit.InvalidDeclUnit x) {
                return Loc._SyntheticLoc();
            }
        });
    }

    public static Loc from(Identifier name) {
        return name == null ? Loc._SyntheticLoc() : name.loc;
    }

    public static Loc from(LexicalError error) {
        return error.match(new LexicalError.MatchBlock<Loc>(){

            @Override
            public Loc _case(LexicalError.UnexpectedLexicalError x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.UnrecognizedSymbol x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.UnexpectedSymbol x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.SymbolNotInExpectedSet x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.SymbolInUnexpectedSet x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.SymbolNotInRange x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.UnterminatedString x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.UnterminatedComment x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.InvalidIdentifier x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.InvalidControlChar x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.InvalidSymbol x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.InvalidTime x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.InvalidDate x) {
                return x.loc;
            }

            @Override
            public Loc _case(LexicalError.InvalidDateTime x) {
                return x.loc;
            }
        });
    }

    public static Loc from(SyntaxError error) {
        return error.match(new SyntaxError.MatchBlock<Loc>(){

            @Override
            public Loc _case(SyntaxError.UnexpectedSyntaxError x) {
                return x.loc;
            }

            @Override
            public Loc _case(SyntaxError.UnexpectedEOF x) {
                return x.loc;
            }

            @Override
            public Loc _case(SyntaxError.IllegalStringLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(SyntaxError.UnexpectedToken x) {
                return x.loc;
            }

            @Override
            public Loc _case(SyntaxError.IllegalIntegerLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(SyntaxError.IllegalLongLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(SyntaxError.IllegalDoubleLiteral x) {
                return x.loc;
            }

            @Override
            public Loc _case(SyntaxError.IllegalDecimalLiteral x) {
                return x.loc;
            }
        });
    }

    public static boolean lessThanOrEqual(Loc left, final Loc right) {
        return left.match(new Loc.MatchBlock<Boolean>(){

            @Override
            public Boolean _case(final Loc.RealLoc left) {
                return right.match(new Loc.MatchBlock<Boolean>(){

                    @Override
                    public Boolean _case(Loc.RealLoc right) {
                        return left.line < right.line || left.line == right.line && left.column < right.column || left.line == right.line && left.column == right.column;
                    }

                    @Override
                    public Boolean _case(Loc.SyntheticLoc right) {
                        return true;
                    }
                });
            }

            @Override
            public Boolean _case(Loc.SyntheticLoc left) {
                return true;
            }
        });
    }

    public static Loc from(UserError error) {
        return error.match(new UserError.MatchBlock<Loc>(){

            @Override
            public Loc _case(UserError.Lexical x) {
                return Location.from(x.error);
            }

            @Override
            public Loc _case(UserError.Syntax x) {
                return Location.from(x.error);
            }
        });
    }

    public static Loc from(final Loc startLoc, final Loc endLoc) {
        return startLoc.match(new Loc.MatchBlock<Loc>(){

            @Override
            public Loc _case(final Loc.RealLoc realStartLoc) {
                return endLoc.match(new Loc.MatchBlock<Loc>(){

                    @Override
                    public Loc _case(Loc.RealLoc realEndLoc) {
                        int startLine = realStartLoc.line;
                        int startColumn = realStartLoc.column;
                        int startIndex = realStartLoc.startIndex;
                        int endIndex = realEndLoc.endIndex;
                        return Loc._RealLoc(startIndex, endIndex, startLine, startColumn);
                    }

                    @Override
                    public Loc _case(Loc.SyntheticLoc x) {
                        return startLoc;
                    }
                });
            }

            @Override
            public Loc _case(Loc.SyntheticLoc x) {
                return endLoc;
            }
        });
    }

    public static Loc from(TriggerUsage usage) {
        return Location.from(Location.from(usage.when), Location.from(usage.action));
    }

    private static Loc from(TriggerWhen when) {
        return when.match(new TriggerWhen.MatchBlock<Loc>(){

            @Override
            public Loc _case(TriggerWhen.TriggerBefore x) {
                return x.loc;
            }

            @Override
            public Loc _case(TriggerWhen.TriggerAfter x) {
                return x.loc;
            }
        });
    }

    private static Loc from(TriggerAction action) {
        return action.match(new TriggerAction.MatchBlock<Loc>(){

            @Override
            public Loc _case(TriggerAction.TriggerInsert x) {
                return x.loc;
            }

            @Override
            public Loc _case(TriggerAction.TriggerUpdate x) {
                return x.loc;
            }

            @Override
            public Loc _case(TriggerAction.TriggerDelete x) {
                return x.loc;
            }

            @Override
            public Loc _case(TriggerAction.TriggerUndelete x) {
                return x.loc;
            }
        });
    }

    public static boolean isReal(Loc loc) {
        return loc.match(new Loc.MatchBlock<Boolean>(){

            @Override
            public Boolean _case(Loc.RealLoc x) {
                return true;
            }

            @Override
            public Boolean _case(Loc.SyntheticLoc x) {
                return false;
            }
        });
    }
}

